package LIMS::DB::RequestErrorCode;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_error_code',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        request_id    => { type => 'integer', not_null => 1 },
        error_code_id => { type => 'integer', not_null => 1 },
        user_id       => { type => 'integer', default => '0', not_null => 1 },
        time          => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
    
    foreign_keys => [
        error_code => {
            class       => 'LIMS::DB::ErrorCode',
            key_columns => { error_code_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
        
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

#=cut

#__PACKAGE__->meta->table('request_error_code');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_error_codes');

1;
