package LIMS::DB::RequestAudit;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_audit',

    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        audit_request_option_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'audit_request_option_id' ],

    foreign_keys => [
        audit_request_option => {
            class       => 'LIMS::DB::AuditRequestOption',
            key_columns => { audit_request_option_id => 'id' },
        },
        
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_audit');

1;