package LIMS::DB::PreRegistrationLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'pre_registration_lab_test',

    columns => [
        id              => { type => 'serial', not_null => 1 },
        reg_specimen_id => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id     => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'reg_specimen_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        reg_specimen => {
            class       => 'LIMS::DB::PreRegistrationSpecimen',
            key_columns => { reg_specimen_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('pre_registration_lab_tests');

1;