package LIMS::DB::Outreach::RequestResult;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'request_results',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        param_id   => { type => 'integer', not_null => 1 },
        result     => { type => 'varchar', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'param_id' ],

    foreign_keys => [
        param => {
            class       => 'LIMS::DB::Outreach::LabParam',
            key_columns => { param_id => 'id' },
            rel_type    => 'one to one',
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_results');

1;