package LIMS::DB::Outreach::RequestPackDispatch;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'request_pack_dispatch',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        pack_due   => { type => 'date' },
        pack_sent  => { type => 'date' },
        return_due => { type => 'date' },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_pack_dispatches');

1;