package LIMS::DB::ClinicalTrial;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table   => 'clinical_trials',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        trial_name  => { type => 'varchar', length => 50 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
    
    unique_key => [ 'trial_name' ],

    relationships => [
        patient_trial => {
            class      => 'LIMS::DB::PatientTrial',
            column_map => { id => 'trial_id' },
            type       => 'one to many',
        },

        request_trial => {
            class      => 'LIMS::DB::RequestTrial',
            column_map => { id => 'trial_id' },
            type       => 'one to many',
        },
    ],
);
#=cut

# or to see what it should be:
#__PACKAGE__->meta->table('clinical_trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('clinical_trials');

1;
