package LIMS::Controller::Roles::SearchConstraint;

use Moose::Role;
use LIMS::Local::Search;

sub generate_search_constraints { 
    my ($self, $data) = @_; # $self->debug($data);

    # need to do specimen code lookup if search includes specimen:
    if ( my $specimen_code = $data->{specimen_code} ) { # warn $sample_code;
        $data->{specimen_id}
            = $self->model('Specimen')->get_specimen_id($specimen_code);
        # delete specimen_code key - no field to match against:
        delete $data->{specimen_code};
    }

    my $user_profile = $self->user_profile;
    
    # args for search object:
    my %args = (
        form_fields  => $data,
        user_profile => $user_profile,
    );

    # create search object:
    my $search = LIMS::Local::Search->new(\%args);

    # generate query from form fields as hashref:
    my $query = $search->generate_query; # $self->debug($query);

    if (%$query) {
        return $query; # return hashref
    }
    else {
        $self->stash->{error_msg} = $self->messages('search')->{empty_submission};
        return 0;
    }
}

1;