package LIMS::Controller::Admin::Lab::Test::SpecimenTypes;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with 'LIMS::Controller::Roles::DataMap';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use LIMS::Local::Sugar;

# ------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('do_admin');

    my $sort_by = $self->query->param('sort_by') || 'sample_code';
    
    my $specimens
        = $self->model('Specimen')->get_specimens({ sort_by => $sort_by });
        
    my $specimen_lab_test_map = $self->specimen_lab_test_map;
    
    $self->tt_params(
        specimens => $specimens,
        specimen_lab_test_map => $specimen_lab_test_map,
    );
    return $self->tt_process;
}

# ------------------------------------------------------------------------------
runmode edit_mode {
    $self->_debug_path($self->get_current_runmode);
    
    return $self->forbidden() unless $self->user_can('do_admin');

    my $lab_test_count = $self->model('Base')->get_objects_count('LabTest');

    my %args = (
        sort_by => $self->query->param('sort_by') || '',
    );
    
	if ( $lab_test_count > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args, total => $lab_test_count });
    }

    # get list of all lab_tests
	my $lab_tests = $self->model('LabTest')->get_lab_tests(\%args);

    my $lab_test_specimen_map = $self->lab_test_specimen_map;
        
    $self->tt_params(
        lab_tests => $lab_tests,
        lab_test_specimen_map => $lab_test_specimen_map,
    );
    return $self->tt_process;
}

# ------------------------------------------------------------------------------
runmode edit  ($errs, $id) {
    $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('do_admin');
    
    # get lab_test + specimen_lab_test data as arrayref:
    my $specimen_lab_test = $self->model('Specimen')->get_specimen_lab_test($id);
    $self->tt_params( data => $specimen_lab_test );
    
    # get all specimens:
    my $specimens = $self->model('Base')->get_objects('Specimen');
    $self->tt_params( specimens => $specimens );

    { # get specimen_lab_test map from $o->specimen_lab_test array:
        my $specimen_lab_tests = $specimen_lab_test->specimen_lab_test;
        my %specimen_lab_test_map
            = map { $_->specimen_id => 1 } @$specimen_lab_tests;
        $self->tt_params( specimen_lab_test_map => \%specimen_lab_test_map );
    }

    return $self->tt_process;
}

# ------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);
    
    return $self->forbidden() unless $self->user_can('do_admin');
    
    $id || return $self->error('no id passed to ' . $self->get_current_runmode);

    my $dfv = $self->check_rm('edit', $self->validate('specimen_lab_test') );
    my $data = $dfv->valid; # only valid param = specimen_id
    
    $data->{lab_test_id} = $id;
    
    my $rtn = $self->model('Specimen')->update_specimen_lab_tests($data);
    
    if ($rtn) {
        return $self->error($rtn);
    }
    else {
        $self->flash( info => $self->messages('action')->{edit_success});
        return $self->redirect( $self->query->url . '/admin/lab_test_specimen-types');
    }
}

1;
