package LIMS::Controller::Admin::Lab::Test;

use strict;

use base 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

#-------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # DEBUG $errs;

    # first check we have at least 1 lab section defined:
	unless ($self->have_lab_sections) {
        $self->stash( error_msg => $self->messages('admin')->{no_sections} );
        return $self->forward('missing_data');
    }

    # get list of lab_sections table data:
    my $sections = $self->model('LabSection')->get_lab_sections();

    unless ($sections) {
        $self->stash( error_msg => $self->messages('admin')->{no_sections} );
    }

	my %args = (); 

	if ( my $lab_section_id = $self->query->param('lab_section_id') ) {
		$args{lab_section_id} = $lab_section_id;
	}
	
    my $total = $self->model('LabTest')->get_lab_tests_count(\%args);

 	$args{sort_by} = $self->query->param('sort_by')
	|| ['lab_section_id', 'field_label'];
	
	if ( $total > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args, total => $total });
    }

    # get list of all lab_tests (restricted by lab_section_id if supplied):
	my $tests = $self->model('LabTest')->get_lab_tests(\%args);

	$self->tt_params(
        tests    => $tests,
        sections => $sections,
    );
	
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_tests');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # DEBUG $errs;

    my $id = $self->param('id')
        || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $test     = $self->model('LabTest')->get_lab_test($id);
    my $sections = $self->model('LabSection')->get_lab_sections(); # no need to sort

    $self->tt_params(
        errs => $errs,
		data 	 => $test,
        sections => $sections,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_tests');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');
	
	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('lab_tests') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
	|| return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('LabTest')->update_lab_tests($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/admin/lab_test' ); # safer to redirect after db edit
}

1;