#
#===============================================================================
#
#  DESCRIPTION: 
#
#===============================================================================
package TestsFor::LIMS::Local::Role::NotTestable;
# will this work? TODO test all combinations of init params to mimic live
# with 'Test::Class::Moose::Role::ParameterizedInstances';
use Modern::Perl;
use utf8;
use Test::Class::Moose;

use Modern::Perl;
use utf8;
 
use DDP;
use Try::Tiny;


use FindBin qw($RealBin);
use LIMS::Local::Config;

my $config = LIMS::Local::Config->instance;
my $production_mode = $config->{settings}->{is_in_production_mode};
with(
    'Test::Class::Moose::Role::AutoUse', 
     'LIMS::Local::Role::NotTestable' => {
        unsafe     => [qw/_unsafe1 _unsafe2/],
        production => 1,
        testing    => 0
    }
);

#todo could use warning_is to catch warnings
sub test_some {
    my $test  = shift;
    my $class = $test->test_class;
    ok("before run ok");

    note "LIVE: p = 1, t = 0";
    is($class->_unsafe1(1, 2, 3) , "unsafe 1 2 3", "runs unsafe code");
    is($class->_unsafe2(1, 2, 3) , "unsafe 1 2 3", "doesnt run no substitute sub");

    TODO:{
             local $TODO = "Can only test one block at a time after setting parameters in 'with' ";
    note "DEV: p = 0, t = 0";
        is($class->_unsafe1(1, 2, 3) , "dev1 1 2 3", "runs dev code");
        is($class->_unsafe2(1, 2, 3) , undef, "doesnt run no substitute sub");

    note "LIVE TEST: p = 1, t = 1";
    is($class->_unsafe1(1, 2, 3) , "testing1 1 2 3", "runs testing code");
    is($class->_unsafe2(1, 2, 3) , undef, "doesnt run no substitute sub");

    };
}
sub _unsafe1 {
   my ($self, @args) = @_;
   return "unsafe @args";
}
sub _unsafe2 {
   my ($self, @args) = @_;
   return "unsafe @args";
}
sub _testing_unsafe1 {
   my ($self, @args) = @_;
   return "testing1 @args";
}
sub _dev_unsafe1 {
   my ($self, @args) = @_;
   return "dev1 @args";
}
1;
