package LIMS::Controller::Admin::Lab::Section;

use strict;

use base 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes( ':all' => 'do_admin' );

#-------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    # get list of lab_sections table data:
    my $sections = $self->model('LabSection')->get_lab_sections({ sort_by => 'section_name' });

	$self->tt_params( sections => $sections );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_sections');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id') || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $section = $self->model('LabSection')->get_lab_section($id);

    $self->tt_params( section => $section );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_sections');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');
	
	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('lab_sections') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
	|| return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('LabSection')->update_lab_sections($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		# set success msg:
		my $msg = $id ? 'edit_success' : 'create_success';
		$self->flash( info => $self->messages('action')->{$msg} );
		return $self->redirect( $self->query->url . '/admin/lab_section' ); # safer to redirect after db edit
	}
}

1;