#
#===============================================================================
#
#  DESCRIPTION:
#
#===============================================================================

package TestsFor::LIMS::Local::IssueTracker;
use Test::Class::Moose;


with 'Test::Class::Moose::Role::AutoUse';

use YAML::Tiny;
use FindBin qw($RealBin);

sub test_some : Tests {
    my $test  = shift;
    my $class = $test->test_class;
    my @card_ids;
    my @lists;

    my $trello;

    {
        # _BUILD_CONFIG dies - corrupted yaml
        my $success = eval {
            $trello = LIMS::Local::IssueTracker->new( config_file =>
                    "$RealBin/config/settings/.leeds/issue_tracking_malformed.yml" );
        };
        ok !$success && $@ =~ /failed to classify line/,
           "died with the YAML error: $@";

        # CHECK_CONFIG dies - yaml without required key
        $success = eval {
            $trello = LIMS::Local::IssueTracker->new( config_file =>
                    "$RealBin/config/settings/.leeds/issue_tracking_missing.yml" );
        };
        ok !$success && $@ =~ /config error/, "died with the config error: $@";

        # correct yaml
        $success = eval {
            $trello = LIMS::Local::IssueTracker->new( config_file =>
                    "$RealBin/../config/settings/.leeds/issue_tracking.yml" );
        };
        ok $success && $@ eq '', "correct yaml file. Plugin loaded.";
        isa_ok $trello , "LIMS::Local::IssueTracker", "Is an LIMS::Local::IssueTracker object";

        ok( $trello->does('MooseX::Object::Pluggable'), "does pluggable" );

        my $plugin = $trello->config->{plugin};
        is $plugin, "Trello", "config set for trello";

    }

    {
       # plugin has create_rfc method
        ok $trello->can("create_rfc"), "can create RFC";

       # dies if given an invailid 'reason'
        my $success = eval {
            $trello->create_rfc(
                {
                    name   => "fail",
                    desc   => "fail description",
                    reason => "invalid reason"
                }
            );
        };
        ok !$success && $@ =~ /Trello error adding label/,
           "died with the Trello error: $@";

        # create issues with all possible reasons
        while ( my ( $key, $value ) = each %{ $trello->config->{colours} } ) {
            my $args = { name => $value, desc => "test1 description", reason => $key };
            my $res = $trello->create_rfc($args);

            is length($res), 24, "http status OK";
            push @card_ids, $res;

        # move the cards around a bit
            if ( ( scalar @card_ids % 2 ) == 0 ) {
                my $to_list =
                    ( scalar @card_ids % 4 ) == 0
                    ? "complete"
                    : "rejected";
                $trello->move_card( $res, $to_list );
                my $card_status = $trello->check_status($res);
                like $card_status , qr/Completed|Rejected/,
                     "card $res in $card_status";

        #is $card_status , "Backlog", "card $res in Backlog";
            }
            else {
                my $card_status = $trello->check_status($res);
                is $card_status , "Backlog", "card $res in Backlog";
            }
        }
    }
    {
        # tests to die when moving cards
        my $success = eval {$trello->move_card( "id")};
        ok !$success && $@ =~ /requires destination/, "move without destination: $@";
        $success = eval {$trello->move_card( "badid" , "complete")};
        ok !$success && $@ =~ /cant move card badid/, "move with bad id: $@";
    }

    {
        # now take list of card_ids and ask which are in complete or rejected lists

        my $complete_ids = $trello->check_complete( \@card_ids );
        my $rejected_ids = $trello->check_rejected( \@card_ids );

        is scalar @{$complete_ids}, 1, "1 card in completed";
        is scalar @{$rejected_ids}, 1, "1 card in rejected";
    }

}

1;

