#!/usr/bin/env perl

# usage:  bin/app.pl -p <port> -c <centre>
# http://localhost:<port>/<centre>

BEGIN {
	use Getopt::Std;
	getopts('c:p:');
	our($opt_c, $opt_p);
}

BEGIN { # set active db to production - default is test
    use FindBin qw($Bin); # warn 'BIN:'.$Bin;

    #$ENV{RDB_DOMAIN} = 'development'; # if using __PACKAGE__->default_domain( $ENV{RDB_DOMAIN}) in LIMS::DB
    $ENV{ROSEDB_DEVINIT} = $Bin . '/../config/rosedb_devinit_devel.pl'; # overrides default db test
    # switch LIMS::RDBO $Rose::DB::Object::Debug on:
    $ENV{RDBO_DEBUG} = 1;
    # flag for QueryLog:
    $ENV{DEVEL_SERVER} = 1;
    # set REPORT_HTML flag - server operates in single-process mode so calling img in url
    # for PDF generation fails:
    $ENV{REPORT_HTML} = 1;
    # option to set centre at command line:
    $ENV{CENTRE} = $opt_c if $opt_c;
}

#use Plack::Middleware::ReverseProxy;
use Plack::Builder;
use Data::Printer;

use lib $Bin . '/../lib';
use LIMS::Dispatch;
use CGI::Application::Server;

my %entry_points = map { '/'.$_ => 'LIMS::Dispatch' } qw(hilis4 bhods); # /hilis4, etc
my $port = $opt_p || 8000; # warn $port;

my $server = CGI::Application::Server->new($port);
$server->document_root($Bin . '/../static');
$server->entry_points(\%entry_points);

builder {
	# enable 'ReverseProxy'; # so original server addr. used instead of localhost
	$server->run;
}
