# creates yaml config for results datafile; needs to be a web-interface

use YAML::Tiny;

use strict;
use FindBin qw($Bin); # warn $Bin;
my $cfg_file = "$Bin/../config/datafiles.txt";

############### data ##########################################################
my @hiv = qw(last_name dob filename date_acquired acquired_by null pdf png txt result_first result_two result_three result_last); 
my @rit = qw(last_name dob filename date_acquired acquired_by null pdf result_first result_two result_three result_four result_last comment);
	
my %hiv_report = (
	specimen_quality => 'adequate',
	clinical_details => 'HIV',
	status       	 => 'default',
	comment          => 'See flow cytometry results',
	diagnosis	     => 'Not required',
);

my %hiv_lab_test = (
	lab_test_name  => 'Immunology', 
	lab_section    => 'Flow cytometry',
	test_type      => 'panel',
	sign_off       => 1, # specify to sign-off lab test
);

my %rit_lab_test = (
	lab_test_name  => 'Rituximab', 
	lab_section    => 'Flow screen',
	test_type      => 'panel',
	sign_off       => 1, # specify to sign-off lab test
);

my %rit_report = (
	specimen_quality => 'adequate',
	clinical_details => 'Rheumatology rituximab study',
	status       	 => 'default',
	comment		     => undef, # supplied by datafile
	diagnosis	     => 'Laboratory tests only',
);
############### data ##########################################################

my $yaml = YAML::Tiny->new;

$yaml->[0]->{HIV} = { 
	fields   => \@hiv, 
	report   => \%hiv_report,
	lab_test => \%hiv_lab_test,
	result_section => 'Flow cytometry',
}; 
$yaml->[0]->{RIT} = { 
	fields   => \@rit, 
	report   => \%rit_report,
	lab_test => \%rit_lab_test, 
	result_section => 'Flow cytometry',
}; 

$yaml->write($cfg_file) or die $!; 
