package LIMS::DB::DiagnosisChangeOption;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'diagnosis_change_options',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        option_name => { type => 'varchar', length => 25 },
        description => { type => 'varchar', length => 255 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'option_name' ],

    relationships => [
        request_diagnosis_history => {
            class      => 'LIMS::DB::RequestDiagnosisHistory',
            column_map => { id => 'option_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('diagnosis_change_options');

1;