package LIMS::DB::ErrorCodeAssignment;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'error_code_assignment',

    columns => [
        type	      => { type => 'enum', check_in => [ 'request', 'patient', 'errors' ], not_null => 1 },
        error_code_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'type', 'error_code_id' ],

    foreign_keys => [
        error_code => {
            class       => 'LIMS::DB::ErrorCode',
            key_columns => { error_code_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('error_code_assigment');

1;
