package LIMS::Controller::Admin::Config::ResultSummaryOptions;

use strict;
use warnings;

use parent 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift; # $self->stash( errs => $errs );    

	my $lab_sections = $self->model('LabSection')->get_lab_sections;

    # first check we have at least 1 lab_section defined:
	unless (@$lab_sections) {
        my $msg = $self->messages('admin')->{no_sections};
        $self->stash( error_msg => $msg );
        return $self->forward('missing_data');
    }

	my $rs_options;
	
    # if we have a result_summary_option selected:
    if ( my $section_id = $self->query->param('id') ) { # warn 'section_id:'.$section_id;
		$rs_options = $self->model('Result')
			->get_results_summary_options_for_section($section_id);
    }

	$self->tt_params(
        lab_sections => $lab_sections,
		rs_options   => $rs_options,
    );
	
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('result_summary_options');

	return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
sub list : Runmode {
	my $self = shift;
	
	# just check we have a param 'id', then forward to default:
    my $id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

	$self->query->param( id => $id );
	return $self->forward('default');	
}

# -------------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('Result')->get_results_summary_option($id);

	my $lab_sections
        = $self->model('LabSection')->get_lab_sections;

    $self->tt_params(
        data         => $data,
        lab_sections => $lab_sections,
    );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('result_summary_options');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $id = $self->param('id') || '';  # $self->debug('id:'.$id);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('result_summary_options') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('Result')->update_result_summary_options($data); 

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		# set success msg:
		my $msg = $id ? 'edit_success' : 'create_success';
		$self->flash( info => $self->messages('action')->{$msg} );
		return  $self->redirect( $self->query->url
			. '/config/result-summary-options/list/' . $data->{lab_section_id} );
	}
}

1;