use XML::Simple qw(:strict);
use Data::Printer;
use Modern::Perl; # say
use Test::More;
use IO::All;

=begin # tests:
tests the genomics_xml.pl script - generates dummy data in lims_test and provides
overrides for location/name of archive & prevents ftp transfer of file
=cut

BEGIN { require 't/test-lib.pl' }

my $dbix = get_dbix();
my $cfg  = get_config(); # p $cfg;
my $db   = 'lims_test'; 

create_genomics_data(); # drop & recreate tables/data

{ # execute genomics_xml.pl script:
    my $script = '/script/crons/hourly/genomics_xml.pl';
    my @args   = ( -d => $db, -t => 10 ); # override dbname, set duration 10 seconds
    system ( $cfg->{path_to_app_root} . $script, @args );
}

# unzip archive and extract to $xml (not using gzip any more):
# gunzip "/tmp/${db}.gz" => \my $xml or die "gunzip failed: $GunzipError\n"; # p $xml;

{ # compare src data and parsed xml hashrefs:
	my $ref = XMLin("/tmp/${db}.xml", ForceArray => 0, KeyAttr => []); # p $ref->{Record};
	my $src = do "/tmp/${db}.txt"; # p $src; # http://www.perlmonks.org/?node_id=304068
	is_deeply($src, $ref->{Record}, 'data structures identical');
}
# delete temp files:
io("/tmp/${db}.$_")->unlink for qw(txt xml);

done_testing(1);

sub create_genomics_data { # create new genomics data:
	my $dbh = $dbix->dbh;
	# drop lab_tests & lab_sections, re-create from genomics db:
	for ( qw/lab_tests lab_sections screens screen_category/ ) {
		$dbh->do(qq!TRUNCATE TABLE `$_`!) ;
		$dbh->do(qq!INSERT INTO `$_` SELECT * FROM `genomics`.`$_`!);
	}
	$dbh->do(qq!TRUNCATE TABLE `$_`!) for qw(request_lab_test_results 
		storage_racks request_initial_screen request_history request_storage);
	
	{ # test/results:
		my %results = map { split ',' } grep chomp $_, <DATA>; # p %vals; exit;
		$dbix->insert('request_lab_test_results',
			{
				lab_test_id => $_,
				request_id  => 1,
				result      => $results{$_},
			}
		) for keys %results;
	}
	$dbix->select('screens', 'id', { description => 'Rare disease' })->into(my $id);
	$dbix->insert('request_initial_screen', { request_id => 1, screen_id => $id });
	$dbix->insert('request_lab_test_history',
		{
			request_id => 1, 
			user_id    => 1, 
			action 	   => 'auto-set Consent taken status to complete', 
		}
	);
	$dbix->insert('request_lab_test_history', 
		{ request_id => 1, action => 'screened', user_id => 1 });
	$dbix->insert('storage_racks', { plateId => 'SR12345' });
	for (1..2) {
		$dbix->insert('request_storage', 
			{
				vial_location => 'C'.$_,
				part_number   => '123456789'.$_,
				request_id    => 1,
				vialId 		  => 'FR1122334'.$_,
				sample 		  => 'tissue',
				source 		  => 'PST',
				rack_id 	  => 1,
			}
		);
	}
	# delete 2nd request - gets included in query, only able to handle 1 request:
	$dbix->delete('requests', { id => 2});
}

__DATA__
1,yes
10,DNA FF Germline
15,2016-02-06
16,R1/R2
17,R2
18,no
19,yes
20,yes
21,yes
22,yes
23,yes
24,yes
25,yes
26,yes
27,yes
28,yes
29,yes
30,yes
31,no
32,3
33,124578
34,235689
35,258369
36,369147
37,147258
38,v2
39,2016-02-08 12:10:00
40,Agarose
41,test result value
42,GMC
43,852369
44,175
45,1254575
46,C5
55,789321
56,225
57,2016-02-06 17:55:26
58,2016-02-07 17:45:10
59,3
60,2016-02-02 18:00:41
61,2016-02-05 17:50:35
62,951753654
63,753951
64,PST
65,25813
66,H3
67,2016-02-04 15:30:30
