#!/usr/bin/perl

#------------------------------------------------------------------------------
# ALTERNATIVE APPROACH IS TO DELETE ALL ENTRIES IN SESSIONS TABLE + DIR AT 4AM
#------------------------------------------------------------------------------

use strict;
use warnings;

use lib '/home/raj/perl5/lib/perl5';

use Data::Dumper;
use Config::Auto;
use CGI::Session::ExpireSessions 1.08;

use FindBin qw($Bin); # warn $Bin;
use lib "$Bin/../../../lib";

use constant DELTA => 24 * 60 * 60; # 1d in seconds
# use constant DELTA => 10; # use for testing -- expire sessions that haven't been accessed in 10 seconds

# print 'Removing sessions that are more than '.DELTA." seconds\n";

use vars qw($fh);
# open my $fh, '>', "$Bin/../../../logs/debug.txt"; # print $fh Dumper \@ARGV;

#-------------------------------------------------------------------------------
unless (@ARGV) { $ARGV[0] = 'leeds' }
#-------------------------------------------------------------------------------

for my $centre (@ARGV) { # print $fh Dumper $centre;
	# can't do this in a loop - only loaded once !!
	# my $config = LIMS::Local::Config->instance(); # _debug($config);
	$ENV{CENTRE} = $centre; # load correct settings file
	
	my $src = "$Bin/../../../config/lims_config.pl"; # _debug($src);
	my $cfg = Config::Auto::parse($src, format => 'perl'); # _debug($cfg);
	my $settings = $cfg->{settings}; # _debug($settings);
	
	my $opts = {
		cgi_session_dsn => { # match method in CGI_SESSION_OPTIONS
			db   => 'driver:mysql;serializer:'.$settings->{db_session_serializer}, 
			file => 'driver:File;serializer:' .$settings->{file_session_serializer}, 
		},
		dsn_args => {
			db => {
				DataSource  => 'dbi:mysql:database='.$settings->{production_db},
				User        => $settings->{db_user_id},
				Password    => $settings->{db_password},
			},
			file => {
				Directory => $Bin.'/../../../sessions',
	#           NoFlock   => '',
	#           Umask     => '',
			}
		},
	}; _debug($opts);

	{ # expire sessions:
		my %args = ( delta => DELTA, verbose => 1 );
		my $expirer = CGI::Session::ExpireSessions->new(%args);

		$expirer->expire_sessions(
			cgi_session_dsn	=> $opts->{cgi_session_dsn}->{file},
			dsn_args		=> $opts->{dsn_args}->{file},
		);
		
		$expirer->expire_sessions(
			cgi_session_dsn	=> $opts->{cgi_session_dsn}->{db},
			dsn_args		=> $opts->{dsn_args}->{db},
		);
	}
}

sub _debug {
	return unless $fh;
	print $fh Dumper @_;
}

__END__
THESE DON'T WORK ANYMORE - REPLACED BY EXAMPLES FROM C::S::E DOCS
# database sessions table:
CGI::Session::ExpireSessions->new(
    delta           => $opts->{delta},
    verbose         => $opts->{verbose},
    dsn_args        => $opts->{dsn_args}->{db},
    cgi_session_dsn => $opts->{cgi_session_dsn}->{db},
)->expire_sessions;

# sessions directory:
CGI::Session::ExpireSessions->new(
    delta           => $opts->{delta},
    verbose         => $opts->{verbose},
    dsn_args        => $opts->{dsn_args}->{file},
    cgi_session_dsn => $opts->{cgi_session_dsn}->{file},
)->expire_sessions;