#!/usr/bin/perl

=begin -------------------------------------------------------------------------
emails list of cases with cytogenetics failed during previous week for all locations
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 0; # email to ra.jones only

############ recipients from contacts.lib ######################################
my @recipients = qw( raj matt.cullen sharon.barrans.secure catherine.cargo.secure );
my $duration = 7; # over past number of days
################################################################################

use lib '/home/raj/perl5/lib/perl5';
use Data::Printer;

use FindBin qw($Bin); # warn $Bin;
use lib $Bin . '/../../../lib';
use LIMS::Local::ScriptHelpers;

# get tools from LIMS::Local::ScriptHelpers:
my $tools = LIMS::Local::ScriptHelpers->new();
$tools->test_only($JUST_TESTING);

#-------------------------------------------------------------------------------
my $date    = $tools->time_now->dmy;
my $subject = "Cytogenetics failed week ending $date";
#-------------------------------------------------------------------------------

my $sql_lib  = $tools->sql_lib();
my $config   = $tools->config();
my $dbix     = $tools->dbix();

my $query = $sql_lib->retr('cytogenetics_failed');

my $result = $dbix->query($query, $duration);

my @rows;
while (my $ref = $result->array) { # warn Dumper $vars; next;
    push @rows, $ref;
}

my $msg = join "\n", map {
	sprintf "%s :: %s :: %s", map $_ ||= 'NULL', @{$_};
} @rows; # print $msg; exit;

my %mail = (
	config  => $config,
	message => $msg,
	subject => $subject,
); # p %mail; p @recipients

$tools->send_mail(\%mail, \@recipients);
