package LIMS::Controller::Admin::Config::ParentOrganisations;

use base 'LIMS::Base';

use LIMS::Local::Sugar;

use Moose;
	with (
		'LIMS::Controller::Roles::SearchConstraint',
		'LIMS::Controller::Roles::LocationSearch',		
	);
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

#-------------------------------------------------------------------------------
startmode default ($errs) { 
    $self->_debug_path($self->get_current_runmode);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('parent_organisations');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode search {
    $self->_debug_path($self->get_current_runmode); 
	# function located in LIMS::Controller::Roles::SourceSearch:	
	return $self->parent_organisation_search;	
}

#-------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('ReferralSource')->get_parent_organisation($id);

    $self->tt_params(
        errs => $errs,
		data => $data,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('parent_organisations');

	#return $self->dump_html;
    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('parent_organisations') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ( $id ) {
		$data->{id} = $id;
	}

    my $rtn = $self->model('ReferralSource')->update_parent_organisations($data); # $self->debug($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		# set success message:
		my $msg = $id ? 'edit_success' : 'create_success';
		$self->flash( info => $self->messages('action')->{$msg} );
		$self->redirect( $self->query->url . '/config/parent-organisations' );
	}
}

#-------------------------------------------------------------------------------
=begin
runmode delete ($id) {
    my $errs = shift; $self->_debug_path($self->get_current_runmode);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    # need confirmation to delete record:
    if ( $self->query->param('confirm_delete') ) {
        my $redirect_url = $self->query->url . '/config/organisation-map';

        # successful delete (or no such record) returns true:
        if ( $self->model('OrganisationMap')->delete_map($id) ) {
			$self->flash( info => $self->messages('delete_success') );
			return $self->redirect( $redirect_url );
		}
		else {
			return $self->error('Sorry - delete failed, I\'ve no idea why.');
		}
    }
    # just return template with form:
    else {
		my $map = $self->model('OrganisationMap')->get_organisation_map($id);
		$self->tt_params( map => $map );
        return $self->tt_process;
    }
}
=cut

1;