package LIMS::Local::Role::Worklist;

use Moose::Role;
use Data::Dumper;
use File::Basename;
use namespace::autoclean;

sub get_fish_custom_template_names {
    my $self = shift;
    my $fish_path = q{worklist/local/fish}; # all our tt files for this runmode

    # work out the path to the template files
    my $template_paths = $self->tt_include_path; # candidates for template file path
    my $correct_template_path; # path to template files
    foreach (@$template_paths) {
        my $path = "$_/$fish_path/templates";
        if ( -d -x $path ) {
            $correct_template_path = $path;
            last;
        }
    }
    if ( not defined $correct_template_path ) {
        die q{Template directory for fish custom templates}
          . q{ doesn't exist or is not executable};
    }

    return glob "$correct_template_path/*";
}

sub _get_fish_panel_probes_as_test_names {
    my $self = shift; $self->_debug_path();

    my $o = $self->model('LabTest')->get_panel_lab_tests('fish');

    # need HoA:
    my %probes = ();
    for (@$o) {
        my $panel_name = $_->panel_test->test_name;
        my $probe_name = $_->lab_test->test_name;
        push @{ $probes{$panel_name} }, $probe_name;
    } # warn Dumper \%probes;
    return \%probes;
}
1;

__END__
=pod

=encoding UTF-8
=for stopwords LIMS::Local::Role::Worklist

=head1 NAME

LIMS::Local::Role::Worklist -

=head1 VERSION

version 0.01

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 SUBROUTINES/METHODS

=head2

=head1 DIAGNOSTICS

=head1 CONFIGURATION AND ENVIRONMENT

=head1 DEPENDENCIES

=head1 BUGS AND LIMITATIONS

=head1 AUTHOR

Garry Quested <garry.quested@nhs.net>

=head1 SEE ALSO

perl(1).

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2018, HMDS.  All Rights Reserved.

This script is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.


