#!/bin/sh

#=========================================================================
# daily archive of hilis4 & hmrn mysql databases
#=========================================================================

# --ignore-table = MyISAM tables (not compatible with single-transaction)

DBUSER=$(perl -e 'my $info = do "/home/raj/apps/HILIS4/script/crons/lib/settings.cfg"; print $info->{hilis_admin}{user}')
DBPASS=$(perl -e 'my $info = do "/home/raj/apps/HILIS4/script/crons/lib/settings.cfg"; print $info->{hilis_admin}{pass}')

ARCHIVEPATH=/home/ecsg

mysqldump -u $DBUSER -p$DBPASS \
--single-transaction \
--quick \
--add-locks \
--ignore-table=hilis4.sessions \
--ignore-table=hilis4.email_addresses \
--ignore-table=hilis4._request_gross_description \
--ignore-table=hilis4._request_report \
--databases hilis4 hmrn \
| gzip -9 - >$ARCHIVEPATH/hmrn_hilis4.sql.gz # -9 = best compression

# temporary send to james on test server.
# jameshmrn configured in ~raj/.ssh/config
# TODO replace with direct send to HMRN once they have an api we can use

scp $ARCHIVEPATH/hmrn_hilis4.sql.gz jameshmrn:hmrn/
