package LIMS::DB::Outreach::ResultType;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'result_types',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', length => 25, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    relationships => [
        lab_params => {
            class      => 'LIMS::DB::Outreach::LabParam',
            column_map => { id => 'department_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('result_types');

1;
