package LIMS::Local::MooX::Types;

use MooX::Types::MooseLike;
use base qw(Exporter);
our @EXPORT_OK = ();

# define some types
my @defs = (
	{
		name 	=> 'NetHL7Request',
		test 	=> sub { ref $_[0] eq 'Net::HL7::Request' },
		message => sub { "$_[0] is not a Net::HL7::Request object" }
	},
	{
		name 	=> 'NetHL7Connection',
		test 	=> sub { ref $_[0] eq 'Net::HL7::Connection' },
		message => sub { "$_[0] is not a Net::HL7::Connection object" }
	},
	{
        name 	=> 'HashReference',
        test	=> sub { ref $_[0] eq 'HASH' },
        message => sub { "$_[0] is not a hashref" }
	},
	{
        name 	=> 'ArrayReference',
        test	=> sub { ref $_[0] eq 'ARRAY' },
        message => sub { "$_[0] is not an arrayref" }
	},
    { # from the  docs: isa => VarChar[25]:
        name => 'VarChar',
        test => sub {
            my ($value, $param) = @_;
            length($value) <= $param;
        },
        message => sub { "$_[0] is too large! It should be <= $_[1]" }
    },
);
MooX::Types::MooseLike::register_types(\@defs, __PACKAGE__);

1;
