package LIMS::DB::RequestResultSummary;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_result_summaries',

    columns => [
        request_id      => { type => 'integer', not_null => 1 },
        lab_section_id  => { type => 'integer', default => '0', not_null => 1 },
        results_summary => { type => 'text', length => 65535 },
        time            => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('request_result_summaries');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_result_summaries');

1;
