package LIMS::Local::Config;

# creates config data as singleton instance - only requires cfg file read once
# for as many app calls as necessary

use strict;
use warnings;

use base qw(Class::Singleton);

use IO::Dir;
use Config::Auto;
use Data::Dumper;
use LIMS::Local::Utils;

sub _new_instance { # warn '*** LOADING LIMS::Local::Config::instance ***'; # should be called once only
    my $class = shift; 

    my $path_to_app_root = LIMS::Local::Utils::find_home(); # warn 'path_to_app_root:'.$path_to_app_root;

    my $d = IO::Dir->new($path_to_app_root . '/config')
	|| die "undefined \$d in $0", $@;

    # load any lims_*.pl files in config dir:
    my @config_files =
        map { $path_to_app_root . '/config/' . $_ }
            grep { $_ =~ /lims_(.*)\.pl$/ } # lims_*.pl
                $d->read; # warn Dumper \@config_files;

    my %combined = ();
    
    for my $file ( @config_files ) {
        my $cfg = Config::Auto::parse($file, format => 'perl');
        %combined = (%combined, %$cfg);
    } # warn Dumper \%combined;
    
    return \%combined;
}

1;