package LIMS::DB::SpecimenLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'specimen_lab_test',

    columns => [
        specimen_id => { type => 'integer', not_null => 1 },
        lab_test_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'specimen_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::DB::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('specimen_lab_test');

1;
