package LIMS::Model::Email;

use Moose;
extends 'LIMS::Model::Base';
with (
    'LIMS::Model::Roles::SessionData', # provides $self->user_profile
    'LIMS::Model::Roles::HistoryAction',
);

use namespace::clean -except => 'meta';

has form_data => ( is => 'rw', isa => 'HashRef', default => sub { {} } );

__PACKAGE__->meta->make_immutable;

use LIMS::Local::Mail qw(dispatch);

#-------------------------------------------------------------------------------
sub diagnosis_status_alert {
    my $self = shift;
    my $data = shift; # hashref of: recipients (arrayref), settings (hashref),
                      # message (str), subject (str)
    
    my $recipients = $data->{all_recipients}; # arrayref
    
    my $db = $self->lims_db; # ie LIMS::DB->new_or_cached;
    
	for my $contact (@$recipients) {
		$data->{recipient} = $contact;
        # forward $data to send_messsage() - will ignore $data->{all_recipients}:
    	if ( my $rtn = $self->send_message($data) ) { # returns error or empty
            return $rtn;
        }
        $self->add_to_actions('e-mailed diagnosis status alert to ' . $contact);
    }
    
    $self->do_request_history();
    
    return 0;
}

#-------------------------------------------------------------------------------
sub send_message {
    my $self = shift;
    my $data = shift; # hashref of: recipient (str), config (hashref),
                      # message (str), subject (str), sender (str; optional)

    my %mail = (
        to       => $data->{recipient},
        from     => $data->{sender} || $data->{config}->{email_from},
        smtp     => $data->{config}->{smtp},
        subject  => $data->{subject},
        message  => $data->{message},
		_app_cfg => $data->{config}, # ignored by Mail::Sendmail::sendmail
    ); # $self->debug(\%mail); 
    
    my $rtn = LIMS::Local::Mail::dispatch(\%mail); # returns error or empty
    return $rtn || 0;    
}

#-------------------------------------------------------------------------------
sub send_attachment {
    my $self = shift;
    my $data = shift; # hashref of: recipient (str), config (hashref),
                      # message (str), subject (str), attachment (binary),
                      # sender (str; optional)
	
    my %mail = (
        to       => $data->{recipient},
        from     => $data->{sender} || $data->{config}->{email_from},
        smtp     => $data->{config}->{smtp},
        subject  => $data->{subject},
        message  => $data->{message},
        file     => $data->{attachment},
        filename => $data->{filename},
		_app_cfg => $data->{config}, # filtered out by send_attachment()
    ); # $self->debug(\%mail); 
    
    my $rtn = LIMS::Local::Mail::send_attachment(\%mail); # returns hasheref
    return $rtn;    
}

#-------------------------------------------------------------------------------
sub add_new_address {
    my ($self, $recipient) = @_;
	# add address if not exists:
	my $o = LIMS::DB::EmailAddress->new(address => $recipient)->load_or_insert;	
}

#-------------------------------------------------------------------------------
sub set_request_id {
    my ($self, $request_id) = @_;
    
    # set form_data params for do_request_history():
    $self->form_data({ _request_id => $request_id });
}

1;