package LIMS::Model::Chart;

use Moose;
with 'LIMS::Model::Roles::DBIxSimple'; # get_sql_with_constraint()
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use LIMS::Local::Utils;
use Data::Dumper;

# using 'warn' requires SELECT to be uppercase to avoid dumping to apache error.log

# ------------------------------------------------------------------------------
sub get_diagnosis_frequency {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);

=begin
    my %args = (
#        query => [ 'time' => { ge => DateTime->now->year } ], # doesn't work
        group_by => 'name',
        require_objects => 'diagnosis',
    );
$self->set_rose_debug(1);    
    my $data = LIMS::DB::RequestReport::Manager->get_request_report(%args);
$self->set_rose_debug(0); 
=cut
	
	my $dbix = $self->lims_dbix;
	
    # joining request_history is deadly slow
#    $db->dbh->do( q!drop table if exists `bar`! );
#    $db->dbh->do( q!create temporary table `bar` (id INT)! );
    
#    $db->dbh->do( q!insert into bar select request_id from request_history where
#        action = 'reported' and year(time) = ?!, undef, DateTime->now->year );
    
    my $sql = $self->get_sql_with_constraint('diagnosis_frequency', 'created_at');
    
	my $data = $dbix->query( $sql )->arrays;	
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

# ------------------------------------------------------------------------------
sub get_new_diagnosis_frequency {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);
	
	my $dbix = $self->lims_dbix;
	
    my $sql
        = $self->get_sql_with_constraint('new_diagnosis_frequency', 'created_at');

	my $data = $dbix->query( $sql )->arrays;
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

# ------------------------------------------------------------------------------
sub get_specimen_frequency {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);
	
	my $dbix = $self->lims_dbix;
	
    my $sql
        = $self->get_sql_with_constraint('specimen_frequency', 'created_at');

	my $data = $dbix->query( $sql )->arrays;
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

# ------------------------------------------------------------------------------
sub get_presentation_frequency {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);

	
	my $dbix = $self->lims_dbix;
	
    my $sql
        = $self->get_sql_with_constraint('presentation_frequency', 'created_at');

	my $data = $dbix->query( $sql )->arrays;
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

# ------------------------------------------------------------------------------
sub get_diagnosis_status {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);
    
	my $dbix = $self->lims_dbix;
    
    my $sql = $self->get_sql_with_constraint('diagnosis_status', 'created_at');

	my $data = $dbix->query( $sql )->arrays; # $self->debug($data);	
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

# ------------------------------------------------------------------------------
sub requests_by_day_of_week {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);

	my $dbix = $self->lims_dbix;
    
    my $sql
        = $self->get_sql_with_constraint('requests_by_day_of_week', 'created_at');

	my $data = $dbix->query( $sql )->arrays; # $self->debug($data);
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

# ------------------------------------------------------------------------------
sub requests_by_month {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);

	my $dbix = $self->lims_dbix;
    
    # set constraint_type to override default:
    my @constraints = qw(created_at all_data);
    
    my $sql = $self->get_sql_with_constraint('requests_by_month', @constraints);

	my $data = $dbix->query( $sql )->arrays; # $self->debug($data);
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}

#-------------------------------------------------------------------------------
sub requests_by_year {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);

	my $dbix = $self->lims_dbix;
    
	my $sql = $self->sql_lib->retr('requests_by_year'); # warn $sql;

	my $data = $dbix->query( $sql )->arrays; # $self->debug($data);
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}
    
#-------------------------------------------------------------------------------
sub specimens_by_year {
    my $self = shift;
    my $vars = shift || {}; # optional form params

    $self->params($vars);

	my $dbix = $self->lims_dbix;
    
	my $sql = $self->sql_lib->retr('specimens_by_year'); # warn $sql;
	
	my $data = $dbix->query( $sql )->arrays; # $self->debug($data);	
    my $title = $self->constraint_title; # set in Role::DBIxSimple
    
    return ($data, $title);
}
    
#-------------------------------------------------------------------------------
sub get_param_monitoring_data {
	my ($self, $args) = @_; # hashref of patient_id, lab_section & screen term

	my $dbix = $self->lims_dbix;
	my $sql  = $self->sql_lib->retr('lab_param_monitoring_data');
	
	my @params = (
		$args->{patient_id},
		$args->{lab_section},
		$args->{presentation},
	); # warn Dumper [ $sql, \@params ];
	
	# return array of hashrefs in ascending date order:
	my $data = $dbix->query( $sql, @params )->hashes; # warn Dumper $data;
	
    return $data;	
}

1;