#!/usr/bin/env perl

=begin
Extract a single table from mysqldump output (either compressed as .gz or .sql file
format). This Perl script will extract a single table definition and its data from
a large mysqldump file. Very nice tool for quick restorations from backups.

adapted from: Dave Bennett (dbennett at bensoft com)
http://dev.mysql.com/doc/refman/5.6/en/mysqldump.html

Usage: zcat {mysqldump}.gz | perl $0 {table} OR perl $0 {table} < {mysqldump}.sql
then:  mysql -uraj -p {db name} < {table}.sql
=cut

use strict;
use warnings;

my $table_name = $ARGV[0]
    or die "zcat {src}.gz | perl $0 {table} OR perl $0 {table} < {src}.sql";

my $regex = qr(^-- Table structure for table `$table_name`);

open my $fh, '>', "./${table_name}.sql" or die $!;

my $run = 0;

while (<STDIN>) {
    last if ( $run && m/^\-\- Table structure/ ); # reached start of next table def 
    $run++ if ( m/$regex/ and !$run ); # regex matches, flag to begin output
    next unless $run;
    print $fh $_; # print to output until start of next table def
}

exit 0;

=begin # same as above
while (<STDIN>) {
 if (  $run && m/^\-\- Table structure/ ) { exit; } # start of next table def 
 if ( !$run && m/$regex/i ) { $run++; } # regex matches, start output flag
 if (  $run ) { print $fh $_; } # print to stdout until start of next table def
}
=cut