#!/usr/bin/perl -w

# fastcgi for use as Apache process:
# FastCgiServer /path/to/lims.fcgi -processes 2

use strict;
use warnings;

BEGIN { # set active db to production - default is `test`
    use FindBin qw($Bin); # warn 'BIN:'.$Bin;
    $ENV{CENTRE} = $ARGV[0]; # accept args from apache config
    # set lib paths for app:
    use lib (
        '/home/raj/perl5/lib/perl5',
        "$Bin/../lib",
        "$Bin/..",
    );
}

use CGI::Fast();
use LIMS::Dispatch;

=begin
use FCGI::ProcManager;

my $proc_manager = FCGI::ProcManager->new({processes => 2});
$proc_manager->pm_manage();
=cut

while ( my $q = CGI::Fast->new() ) {
#    $proc_manager -> pm_pre_dispatch();

    # override default db test:
    $ENV{ROSEDB_DEVINIT} = "$Bin/../config/rosedb_devinit_prod.pl";
    # set flag for LIMS::_set_cgisession_options & QueryLog:
    $ENV{FAST_CGI} = 1;

	$ENV{RDBO_DEBUG} = 1; # switch LIMS::RDBO $Rose::DB::Object::Debug on

    eval {
        LIMS::Dispatch->dispatch(
            args_to_new => { QUERY => $q },
            default => '',
            debug => 0,
        );
    };

#    $proc_manager -> pm_post_dispatch();

	# warn $@ if $@;
	my $err = $@;
	if ($err) {
		warn "$0 error: $err";
		exit 0; # to free $dbh from stuck transaction and restart process(es)
	}
}
