package LIMS::DB::Outreach::NodalOption;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'nodal_options',

    columns => [
        id     => { type => 'integer', not_null => 1 },
        option => { type => 'varchar', length => 25 },
    ],

    primary_key_columns => [ 'id' ],

    relationships => [
        questionnaire_adenopathy => {
            class      => 'LIMS::DB::Outreach::QuestionnaireAdenopathy',
            column_map => { id => 'nodal_option_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('nodal_options');

1;
