package LIMS::DB::Outreach::PatientDispatchDetail;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'patient_dispatch_detail',

    columns => [
        patient_id  => { type => 'integer', not_null => 1 },
        dispatch_to => { type => 'enum', check_in => [ 'home', 'alternate', 'GP' ],
            default => 'home', not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('patient_dispatch_details');

1;