package LIMS::DB::AuditRequestCategory;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'audit_request_categories',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        description => { type => 'varchar', length => 255, not_null => 1 },
        active	    => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        audit_request_options => {
            class      => 'LIMS::DB::AuditRequestOption',
            column_map => { id => 'category_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('audit_request_categories');

1;
