-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               5.5.55-0+deb7u1 - (Debian)
-- Server OS:                    debian-linux-gnu
-- HeidiSQL Version:             9.5.0.5196
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table hmrn_test.antecedent_events
CREATE TABLE IF NOT EXISTS `antecedent_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.antecedent_events: ~23 rows (approximately)
/*!40000 ALTER TABLE `antecedent_events` DISABLE KEYS */;
INSERT INTO `antecedent_events` (`id`, `event`) VALUES
	(1, 'Haematological malignancy'),
	(2, 'Non-haematological malignancy'),
	(3, 'Down\'s syndrome'),
	(4, 'Sjogren\'s syndrome'),
	(5, 'Hashimoto\'s thyroiditis'),
	(6, 'Organ transplantation'),
	(7, 'Helicobacter pylori'),
	(8, 'Immunodeficiency'),
	(9, 'Coeliac disease'),
	(10, 'Monoclonal gammopathy'),
	(11, 'Monoclonal B lymphocytosis'),
	(12, 'Haem & non-haem malignancies'),
	(13, 'Rheumatoid arthritis'),
	(14, 'Unknown'),
	(15, 'None'),
	(16, 'Other (see comments)'),
	(17, 'Aplastic anaemia'),
	(18, 'SLE'),
	(19, 'Haemolytic anaemia'),
	(20, 'Benign haematology'),
	(21, 'Auto-immune disorder'),
	(22, 'Polymyaligia rheumatica'),
	(23, 'Kidney disease');
/*!40000 ALTER TABLE `antecedent_events` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.categories
CREATE TABLE IF NOT EXISTS `categories` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.categories: ~4 rows (approximately)
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` (`id`, `category`) VALUES
	(1, 'precursor'),
	(2, 'myeloid'),
	(3, 'lymphoid'),
	(4, 'plasmacell');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.category_parameter
CREATE TABLE IF NOT EXISTS `category_parameter` (
  `category_id` smallint(6) NOT NULL DEFAULT '0',
  `parameter_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`,`parameter_id`),
  KEY `parameter_id` (`parameter_id`),
  CONSTRAINT `category_parameter_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `category_parameter_ibfk_2` FOREIGN KEY (`parameter_id`) REFERENCES `parameters` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.category_parameter: ~72 rows (approximately)
/*!40000 ALTER TABLE `category_parameter` DISABLE KEYS */;
INSERT INTO `category_parameter` (`category_id`, `parameter_id`) VALUES
	(4, 2),
	(3, 3),
	(4, 3),
	(3, 4),
	(4, 4),
	(4, 5),
	(1, 6),
	(2, 6),
	(3, 6),
	(4, 6),
	(3, 7),
	(4, 7),
	(4, 8),
	(3, 9),
	(4, 9),
	(4, 11),
	(3, 12),
	(4, 12),
	(4, 13),
	(4, 14),
	(4, 15),
	(1, 16),
	(2, 16),
	(3, 16),
	(4, 16),
	(3, 17),
	(1, 18),
	(2, 18),
	(3, 18),
	(4, 18),
	(1, 19),
	(2, 19),
	(3, 19),
	(4, 19),
	(3, 20),
	(4, 20),
	(3, 21),
	(3, 22),
	(3, 23),
	(3, 24),
	(3, 25),
	(3, 26),
	(3, 27),
	(1, 28),
	(2, 28),
	(3, 28),
	(4, 28),
	(2, 29),
	(2, 30),
	(2, 31),
	(2, 32),
	(2, 33),
	(2, 35),
	(2, 36),
	(2, 37),
	(2, 38),
	(4, 39),
	(1, 40),
	(2, 40),
	(3, 40),
	(4, 40),
	(1, 41),
	(2, 41),
	(3, 41),
	(4, 41),
	(1, 42),
	(2, 42),
	(3, 42),
	(4, 42),
	(4, 45),
	(4, 47),
	(3, 49);
/*!40000 ALTER TABLE `category_parameter` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.defaults_and_ranges
CREATE TABLE IF NOT EXISTS `defaults_and_ranges` (
  `param_id` int(11) NOT NULL DEFAULT '0',
  `min_value` decimal(2,1) NOT NULL DEFAULT '0.0',
  `max_value` decimal(10,1) NOT NULL DEFAULT '0.0',
  `not_stated` decimal(10,1) NOT NULL DEFAULT '0.0',
  `not_done` decimal(10,1) NOT NULL DEFAULT '0.0',
  PRIMARY KEY (`param_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table hmrn_test.defaults_and_ranges: ~17 rows (approximately)
/*!40000 ALTER TABLE `defaults_and_ranges` DISABLE KEYS */;
INSERT INTO `defaults_and_ranges` (`param_id`, `min_value`, `max_value`, `not_stated`, `not_done`) VALUES
	(4, 0.0, 800.0, 888.0, 999.0),
	(6, 1.0, 25.0, 88.8, 99.9),
	(7, 0.0, 80.0, 88.0, 99.0),
	(8, 9.0, 2200.0, 8888.0, 9999.0),
	(14, 0.0, 80000.0, 88888.0, 99999.0),
	(15, 0.0, 80000.0, 88888.0, 99999.0),
	(18, 0.1, 8000.0, 8888.0, 9999.0),
	(19, 0.1, 8000.0, 8888.0, 9999.0),
	(20, 1.0, 70.0, 888.0, 999.0),
	(28, 1.0, 8000.0, 8888.0, 9999.0),
	(37, 0.0, 100.0, 888.0, 999.0),
	(39, 0.0, 80.0, 88.8, 99.9),
	(40, 0.0, 800.0, 888.0, 999.0),
	(41, 0.0, 800.0, 888.0, 999.0),
	(42, 0.0, 70.0, 88.8, 99.9),
	(46, 0.0, 100.0, 888.0, 999.0),
	(47, 0.0, 100.0, 888.0, 999.0);
/*!40000 ALTER TABLE `defaults_and_ranges` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.events
CREATE TABLE IF NOT EXISTS `events` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.events: ~4 rows (approximately)
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` (`id`, `description`) VALUES
	(1, 'diagnosis'),
	(2, 'first_appointment'),
	(3, 'palliative_care'),
	(4, 'deceased');
/*!40000 ALTER TABLE `events` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.history
CREATE TABLE IF NOT EXISTS `history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `user_id` smallint(6) NOT NULL DEFAULT '0',
  `action` varchar(255) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.history: ~3,850 rows (approximately)
/*!40000 ALTER TABLE `history` DISABLE KEYS */;
/*!40000 ALTER TABLE `history` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.imaging_options
CREATE TABLE IF NOT EXISTS `imaging_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  `option_type` enum('upper_nodal','lower_nodal','extranodal','flag') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.imaging_options: ~42 rows (approximately)
/*!40000 ALTER TABLE `imaging_options` DISABLE KEYS */;
INSERT INTO `imaging_options` (`id`, `description`, `option_type`) VALUES
	(1, 'cns', 'extranodal'),
	(2, 'git', 'extranodal'),
	(3, 'gu', 'extranodal'),
	(4, 'blood', 'extranodal'),
	(5, 'bone', 'extranodal'),
	(6, 'liver', 'extranodal'),
	(7, 'pulmonary_left', 'extranodal'),
	(8, 'pulmonary_right', 'extranodal'),
	(9, 'marrow', 'extranodal'),
	(10, 'orbit_left', 'extranodal'),
	(11, 'orbit_right', 'extranodal'),
	(12, 'skin', 'extranodal'),
	(13, 'salivary_gland_left', 'extranodal'),
	(14, 'salivary_gland_right', 'extranodal'),
	(15, 'thyroid', 'extranodal'),
	(16, 'pericardium', 'extranodal'),
	(17, 'muscle', 'extranodal'),
	(18, 'waldeyer', 'upper_nodal'),
	(19, 'neck_left', 'upper_nodal'),
	(20, 'neck_right', 'upper_nodal'),
	(21, 'infraclavicular_left', 'upper_nodal'),
	(22, 'infraclavicular_right', 'upper_nodal'),
	(23, 'axillary_left', 'upper_nodal'),
	(24, 'axillary_right', 'upper_nodal'),
	(25, 'arm_left', 'upper_nodal'),
	(26, 'arm_right', 'upper_nodal'),
	(27, 'thymus', 'upper_nodal'),
	(28, 'mediastinal', 'upper_nodal'),
	(29, 'hilar_left', 'upper_nodal'),
	(30, 'hilar_right', 'upper_nodal'),
	(31, 'para_aortic', 'lower_nodal'),
	(32, 'mesenteric', 'lower_nodal'),
	(33, 'iliac_left', 'lower_nodal'),
	(34, 'iliac_right', 'lower_nodal'),
	(35, 'inguinal_left', 'lower_nodal'),
	(36, 'inguinal_right', 'lower_nodal'),
	(37, 'popliteal_left', 'lower_nodal'),
	(38, 'popliteal_right', 'lower_nodal'),
	(39, 'spleen', 'lower_nodal'),
	(40, 'extensive', 'flag'),
	(41, 'bulky', 'flag'),
	(42, 'check_scan', 'flag');
/*!40000 ALTER TABLE `imaging_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.locations
CREATE TABLE IF NOT EXISTS `locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.locations: ~17 rows (approximately)
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
INSERT INTO `locations` (`id`, `location`) VALUES
	(1, 'Hull'),
	(2, 'Mid-Yorks'),
	(3, 'York'),
	(4, 'Leeds'),
	(5, 'Airedale'),
	(6, 'Calderdale'),
	(7, 'Harrogate'),
	(8, 'Scarborough'),
	(9, 'Bradford'),
	(10, 'Middlesborough'),
	(11, 'Scunthorpe'),
	(12, 'Grimsby (DPW)'),
	(13, 'Nottingham'),
	(14, 'Lincoln County'),
	(15, 'Newcastle'),
	(16, 'Sheffield'),
	(17, 'Christie');
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.menu_items
CREATE TABLE IF NOT EXISTS `menu_items` (
  `item_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `item_value` (`item_value`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.menu_items: ~64 rows (approximately)
/*!40000 ALTER TABLE `menu_items` DISABLE KEYS */;
INSERT INTO `menu_items` (`item_id`, `item_value`) VALUES
	(1, '0'),
	(2, '1'),
	(3, '2'),
	(4, '3'),
	(31, '4'),
	(5, '7'),
	(32, '8'),
	(33, '9'),
	(17, 'A'),
	(18, 'B'),
	(13, 'both'),
	(19, 'C'),
	(61, 'CT'),
	(64, 'CT and PET'),
	(26, 'equivocal'),
	(45, 'good'),
	(36, 'I'),
	(37, 'IE'),
	(48, 'IgA'),
	(53, 'IgA & IgG'),
	(49, 'IgD'),
	(50, 'IgE'),
	(51, 'IgG'),
	(54, 'IgG & IgM'),
	(52, 'IgM'),
	(38, 'II'),
	(39, 'IIE'),
	(41, 'III'),
	(42, 'IIIE'),
	(43, 'IIIS'),
	(40, 'IIS'),
	(46, 'intermediate'),
	(44, 'IV'),
	(58, 'kappa'),
	(59, 'lambda'),
	(55, 'light-chain only'),
	(6, 'low'),
	(20, 'lytic'),
	(63, 'MRI Only'),
	(35, 'multiple'),
	(24, 'multiple fractures'),
	(25, 'multiple types'),
	(15, 'N'),
	(60, 'N/A'),
	(30, 'no'),
	(56, 'non-secretory'),
	(27, 'none'),
	(7, 'normal'),
	(10, 'not done'),
	(21, 'osteopenia'),
	(22, 'osteoporosis'),
	(11, 'palpation'),
	(62, 'PET'),
	(28, 'plasmacytoma'),
	(47, 'poor'),
	(8, 'raised'),
	(34, 'single'),
	(23, 'single fracture'),
	(57, 'suppressed'),
	(16, 'U'),
	(12, 'ultrasound'),
	(9, 'unknown'),
	(14, 'Y'),
	(29, 'yes');
/*!40000 ALTER TABLE `menu_items` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.parameters
CREATE TABLE IF NOT EXISTS `parameters` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `param_name` varchar(25) NOT NULL DEFAULT '',
  `field_type` enum('int','decimal','menu') NOT NULL DEFAULT 'int',
  `is_active` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `param_name` (`param_name`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table hmrn_test.parameters: ~49 rows (approximately)
/*!40000 ALTER TABLE `parameters` DISABLE KEYS */;
INSERT INTO `parameters` (`id`, `param_name`, `field_type`, `is_active`) VALUES
	(1, 'cns', 'menu', 'yes'),
	(2, 'bone_disease', 'menu', 'yes'),
	(3, 'paraprotein', 'menu', 'yes'),
	(4, 'pp_level', 'decimal', 'yes'),
	(5, 'bence_jones', 'menu', 'yes'),
	(6, 'hb', 'decimal', 'yes'),
	(7, 'b2m', 'decimal', 'yes'),
	(8, 'creatinine', 'int', 'yes'),
	(9, 'igs', 'menu', 'yes'),
	(10, 'free_chains', 'menu', 'yes'),
	(11, 'skeletal_survey', 'menu', 'yes'),
	(12, 'mri', 'menu', 'yes'),
	(13, 'bone_lesions', 'menu', 'yes'),
	(14, 'serum_kappa', 'decimal', 'yes'),
	(15, 'serum_lambda', 'decimal', 'yes'),
	(16, 'ecog', 'menu', 'yes'),
	(17, 'ldh', 'menu', 'yes'),
	(18, 'wbc', 'decimal', 'yes'),
	(19, 'lymphs', 'decimal', 'yes'),
	(20, 'albumin', 'int', 'yes'),
	(21, 'ct', 'menu', 'yes'),
	(22, 'bm', 'menu', 'yes'),
	(23, 'sweats', 'menu', 'yes'),
	(24, 'wt_loss', 'menu', 'yes'),
	(25, 'fever', 'menu', 'yes'),
	(26, 'binet', 'menu', 'yes'),
	(27, 'stage', 'menu', 'yes'),
	(28, 'plts', 'int', 'yes'),
	(29, 'splenomegaly', 'menu', 'yes'),
	(30, 'hepatomegaly', 'menu', 'yes'),
	(31, 'detection_spleen', 'menu', 'yes'),
	(32, 'detection_liver', 'menu', 'yes'),
	(33, 'epo', 'menu', 'yes'),
	(34, 'rcm', 'menu', 'yes'),
	(35, 'cytopenias', 'menu', 'yes'),
	(36, 'karyotype', 'menu', 'yes'),
	(37, 'cd34', 'decimal', 'yes'),
	(38, 'transfusion', 'menu', 'yes'),
	(39, 'calcium', 'decimal', 'yes'),
	(40, 'monocytes', 'decimal', 'yes'),
	(41, 'neutrophils', 'decimal', 'yes'),
	(42, 'pcv', 'decimal', 'yes'),
	(43, 'deauville', 'int', 'yes'),
	(44, 'suv_max', 'decimal', 'yes'),
	(45, 'serum_flc', 'menu', 'yes'),
	(46, 'haematocrit_vol', 'decimal', 'yes'),
	(47, 'kappa_lambda_ratio', 'decimal', 'yes'),
	(48, 'scans', 'menu', 'yes'),
	(49, 'pet', 'menu', 'yes');
/*!40000 ALTER TABLE `parameters` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.parameter_menu_item
CREATE TABLE IF NOT EXISTS `parameter_menu_item` (
  `param_id` smallint(5) unsigned NOT NULL,
  `item_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`param_id`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.parameter_menu_item: ~144 rows (approximately)
/*!40000 ALTER TABLE `parameter_menu_item` DISABLE KEYS */;
INSERT INTO `parameter_menu_item` (`param_id`, `item_id`) VALUES
	(1, 14),
	(1, 15),
	(1, 16),
	(2, 9),
	(2, 20),
	(2, 21),
	(2, 22),
	(2, 23),
	(2, 24),
	(2, 25),
	(2, 26),
	(2, 27),
	(2, 28),
	(2, 29),
	(2, 30),
	(3, 9),
	(3, 10),
	(3, 27),
	(3, 48),
	(3, 49),
	(3, 50),
	(3, 51),
	(3, 52),
	(3, 53),
	(3, 54),
	(3, 55),
	(3, 56),
	(5, 9),
	(5, 10),
	(5, 13),
	(5, 27),
	(5, 58),
	(5, 59),
	(9, 7),
	(9, 8),
	(9, 9),
	(9, 57),
	(10, 14),
	(10, 15),
	(10, 16),
	(11, 14),
	(11, 15),
	(11, 16),
	(12, 14),
	(12, 15),
	(12, 16),
	(13, 9),
	(13, 27),
	(13, 34),
	(13, 35),
	(13, 60),
	(16, 1),
	(16, 2),
	(16, 3),
	(16, 4),
	(16, 31),
	(16, 32),
	(16, 33),
	(17, 6),
	(17, 7),
	(17, 8),
	(17, 9),
	(17, 10),
	(21, 14),
	(21, 15),
	(21, 16),
	(22, 14),
	(22, 15),
	(22, 16),
	(23, 14),
	(23, 15),
	(23, 16),
	(24, 14),
	(24, 15),
	(24, 16),
	(25, 14),
	(25, 15),
	(25, 16),
	(26, 16),
	(26, 17),
	(26, 18),
	(26, 19),
	(26, 60),
	(27, 16),
	(27, 36),
	(27, 37),
	(27, 38),
	(27, 39),
	(27, 40),
	(27, 41),
	(27, 42),
	(27, 43),
	(27, 44),
	(29, 14),
	(29, 15),
	(29, 16),
	(30, 14),
	(30, 15),
	(30, 16),
	(31, 9),
	(31, 11),
	(31, 12),
	(31, 13),
	(32, 9),
	(32, 11),
	(32, 12),
	(32, 13),
	(33, 6),
	(33, 7),
	(33, 8),
	(33, 9),
	(33, 10),
	(34, 6),
	(34, 7),
	(34, 8),
	(34, 9),
	(34, 10),
	(35, 1),
	(35, 2),
	(35, 3),
	(35, 4),
	(35, 5),
	(36, 9),
	(36, 45),
	(36, 46),
	(36, 47),
	(38, 14),
	(38, 15),
	(38, 16),
	(45, 9),
	(45, 10),
	(45, 13),
	(45, 27),
	(45, 58),
	(45, 59),
	(48, 9),
	(48, 27),
	(48, 61),
	(48, 62),
	(48, 63),
	(48, 64),
	(49, 14),
	(49, 15),
	(49, 16);
/*!40000 ALTER TABLE `parameter_menu_item` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_antecedent
CREATE TABLE IF NOT EXISTS `patient_antecedent` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `event_id` int(11) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_antecedent: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_antecedent` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_antecedent` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_chronologies
CREATE TABLE IF NOT EXISTS `patient_chronologies` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `diagnosed` date DEFAULT NULL,
  `first_appointment` date DEFAULT NULL,
  `palliative_care` date DEFAULT NULL,
  `deceased` date DEFAULT NULL,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_chronologies: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_chronologies` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_chronologies` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_comments
CREATE TABLE IF NOT EXISTS `patient_comments` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `comment` text NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_comments: ~1 rows (approximately)
/*!40000 ALTER TABLE `patient_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_comments` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_event
CREATE TABLE IF NOT EXISTS `patient_event` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `event_id` smallint(6) NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`patient_id`,`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_event: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_event` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_imaging_event
CREATE TABLE IF NOT EXISTS `patient_imaging_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `dataset` smallint(6) NOT NULL DEFAULT '1',
  `scan_type` enum('ct','pet') DEFAULT NULL,
  `stage` enum('initial','follow-up') NOT NULL DEFAULT 'initial',
  `date` date NOT NULL DEFAULT '1901-01-01',
  PRIMARY KEY (`id`),
  UNIQUE KEY `patient_dataset_type` (`patient_id`,`dataset`,`scan_type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_imaging_event: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_imaging_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_imaging_event` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_imaging_option
CREATE TABLE IF NOT EXISTS `patient_imaging_option` (
  `imaging_event_id` int(11) NOT NULL DEFAULT '0',
  `imaging_option_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`imaging_event_id`,`imaging_option_id`),
  KEY `imaging_options` (`imaging_option_id`),
  CONSTRAINT `fk_patient_imaging_option_imaging_options` FOREIGN KEY (`imaging_option_id`) REFERENCES `imaging_options` (`id`),
  CONSTRAINT `fk_patient_imaging_option_patient_imaging_event` FOREIGN KEY (`imaging_event_id`) REFERENCES `patient_imaging_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_imaging_option: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_imaging_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_imaging_option` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_imaging_other
CREATE TABLE IF NOT EXISTS `patient_imaging_other` (
  `imaging_event_id` int(11) NOT NULL DEFAULT '0',
  `details` varchar(255) NOT NULL DEFAULT '',
  KEY `imaging_event_id` (`imaging_event_id`),
  CONSTRAINT `fk_patient_imaging_other_patient_imaging_event` FOREIGN KEY (`imaging_event_id`) REFERENCES `patient_imaging_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_imaging_other: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_imaging_other` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_imaging_other` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_mdt_dates
CREATE TABLE IF NOT EXISTS `patient_mdt_dates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_mdt_dates: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_mdt_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_mdt_dates` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_params
CREATE TABLE IF NOT EXISTS `patient_params` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `param_id` smallint(6) NOT NULL DEFAULT '0',
  `result` varchar(255) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`,`param_id`),
  KEY `param_id` (`param_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table hmrn_test.patient_params: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_params` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_params` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_pet_score
CREATE TABLE IF NOT EXISTS `patient_pet_score` (
  `imaging_event_id` int(11) NOT NULL DEFAULT '0',
  `param` enum('suv_max','deauville') NOT NULL DEFAULT 'suv_max',
  `result` float DEFAULT NULL,
  PRIMARY KEY (`imaging_event_id`,`param`),
  CONSTRAINT `fk_patient_pet_scan_patient_imaging_event` FOREIGN KEY (`imaging_event_id`) REFERENCES `patient_imaging_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_pet_score: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_pet_score` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_pet_score` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_post_code
CREATE TABLE IF NOT EXISTS `patient_post_code` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `post_code` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_post_code: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_post_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_post_code` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_prior_therapies
CREATE TABLE IF NOT EXISTS `patient_prior_therapies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `therapy` enum('radiotherapy','chemotherapy') DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_prior_therapies: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_prior_therapies` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_prior_therapies` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_referrals
CREATE TABLE IF NOT EXISTS `patient_referrals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `referral_date` date DEFAULT NULL,
  `referral_type_id` smallint(6) NOT NULL DEFAULT '0',
  `from_source_id` smallint(6) NOT NULL DEFAULT '0',
  `to_source_id` smallint(6) NOT NULL DEFAULT '0',
  `date_first_seen` date DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pid` (`patient_id`),
  KEY `FK_referral_type_options` (`referral_type_id`),
  KEY `FK_referral_source_from_options` (`from_source_id`),
  KEY `FK_referral_source_to_options` (`to_source_id`),
  CONSTRAINT `FK_referral_source_from_options` FOREIGN KEY (`from_source_id`) REFERENCES `referral_source_options` (`id`),
  CONSTRAINT `FK_referral_source_to_options` FOREIGN KEY (`to_source_id`) REFERENCES `referral_source_options` (`id`),
  CONSTRAINT `FK_referral_type_options` FOREIGN KEY (`referral_type_id`) REFERENCES `referral_type_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_referrals: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_referrals` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_sites_other
CREATE TABLE IF NOT EXISTS `patient_sites_other` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `details` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_sites_other: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_sites_other` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_sites_other` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_staging_other
CREATE TABLE IF NOT EXISTS `patient_staging_other` (
  `patient_id` int(10) NOT NULL DEFAULT '0',
  `detail` enum('bulky','extensive','check_ct') DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_staging_other: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_staging_other` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_staging_other` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_staging_site
CREATE TABLE IF NOT EXISTS `patient_staging_site` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `site_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`patient_id`,`site_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_staging_site: ~0 rows (approximately)
/*!40000 ALTER TABLE `patient_staging_site` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_staging_site` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.patient_treatment
CREATE TABLE IF NOT EXISTS `patient_treatment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `tx_type_id` int(11) NOT NULL DEFAULT '0',
  `tx_detail_id` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `tx_cycles` float DEFAULT NULL,
  `response_id` int(11) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pid` (`patient_id`),
  KEY `location_id` (`location_id`),
  KEY `tx_type_id` (`tx_type_id`),
  KEY `tx_detail_id` (`tx_detail_id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.patient_treatment: ~1 rows (approximately)
/*!40000 ALTER TABLE `patient_treatment` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_treatment` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.referral_source_options
CREATE TABLE IF NOT EXISTS `referral_source_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.referral_source_options: ~77 rows (approximately)
/*!40000 ALTER TABLE `referral_source_options` DISABLE KEYS */;
INSERT INTO `referral_source_options` (`id`, `description`) VALUES
	(1, 'A&E - GP referral'),
	(2, 'A&E - Self referral'),
	(3, 'A&E - Unknown referral source'),
	(4, 'Acute assessment unit (AAU etc.)'),
	(5, 'Breast surgery'),
	(6, 'Cardiology'),
	(7, 'Cardiothoracic surgery'),
	(8, 'Colorectal surgery'),
	(9, 'Coronary Care Unit (CCU)'),
	(10, 'Dentist'),
	(11, 'Dermatology'),
	(12, 'Elderly medicine '),
	(13, 'Endocrinology/Diabetes'),
	(14, 'Endoscopy'),
	(15, 'ENT (Ear, Nose & Throat)'),
	(16, 'Gastroenterology'),
	(17, 'Gastro-intestinal surgery'),
	(18, 'General surgery'),
	(19, 'GP'),
	(20, 'Gynaecology'),
	(21, 'Haematology'),
	(22, 'High Dependency Unit (HDU)'),
	(23, 'Intensive Care Unit (ICU)'),
	(24, 'Infectious diseases'),
	(25, 'Maxillo-facial surgery'),
	(26, 'Medicine (general)'),
	(27, 'Neuro-medicine'),
	(28, 'Neuro-surgery'),
	(29, 'Obstetrics '),
	(30, 'Oncology'),
	(31, 'Opthalmology'),
	(32, 'Optician'),
	(33, 'Orthopaedic'),
	(34, 'Other'),
	(35, 'Paediatrics'),
	(36, 'Pain team'),
	(37, 'Palliative medicine'),
	(38, 'Plastic/Reconstructive surgery'),
	(39, 'Psychiatry'),
	(40, 'Psycho-oncology'),
	(41, 'Renal medicine'),
	(42, 'Respiratory medicine'),
	(43, 'Rheumatology'),
	(44, 'Unknown'),
	(45, 'Urology'),
	(46, 'Vascular surgery'),
	(47, 'Referred to'),
	(48, 'Pathology'),
	(49, 'Physiotherapy'),
	(50, 'Radiology'),
	(51, 'Medical oncology'),
	(52, 'Gynaecological oncology'),
	(53, 'Clinical oncology'),
	(54, 'Medical assessment unit'),
	(55, 'Sarcoma specialist'),
	(56, 'Self referral'),
	(57, 'Immunology'),
	(58, 'Physiotherapy'),
	(59, 'Hepatology'),
	(60, 'Head & neck surgery'),
	(61, 'Paediatric oncology'),
	(62, 'Laboratory'),
	(63, 'Known to haematology'),
	(64, 'Paediatric haematologist'),
	(65, 'Paediatric'),
	(66, 'Stroke'),
	(67, 'Spinal'),
	(68, 'A&E'),
	(69, 'Midwifery'),
	(70, 'Haematology (private)'),
	(71, 'GP out of hours'),
	(72, 'Haematology – teenage unit'),
	(73, 'Rehabilitation'),
	(74, 'Neuro-oncology'),
	(75, 'Cranio-facial'),
	(76, 'Medical oncology (private) '),
	(77, 'Neurologist (private) ');
/*!40000 ALTER TABLE `referral_source_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.referral_type_options
CREATE TABLE IF NOT EXISTS `referral_type_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.referral_type_options: ~5 rows (approximately)
/*!40000 ALTER TABLE `referral_type_options` DISABLE KEYS */;
INSERT INTO `referral_type_options` (`id`, `description`) VALUES
	(1, 'Routine'),
	(2, '2WW/Urgent'),
	(3, 'Consultant'),
	(4, 'Unknown'),
	(5, 'Other');
/*!40000 ALTER TABLE `referral_type_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.response_options
CREATE TABLE IF NOT EXISTS `response_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.response_options: ~12 rows (approximately)
/*!40000 ALTER TABLE `response_options` DISABLE KEYS */;
INSERT INTO `response_options` (`id`, `description`) VALUES
	(1, 'CR'),
	(2, 'PR'),
	(3, 'SD'),
	(4, 'PD'),
	(5, 'NE'),
	(6, 'sCR'),
	(7, 'VGPR'),
	(8, 'MR'),
	(9, 'Plateau'),
	(10, 'Relapse'),
	(11, 'RfCR'),
	(12, 'MRD+ve');
/*!40000 ALTER TABLE `response_options` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.staging_sites
CREATE TABLE IF NOT EXISTS `staging_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  `location` enum('upper_nodal','lower_nodal','nodal','extranodal') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.staging_sites: ~39 rows (approximately)
/*!40000 ALTER TABLE `staging_sites` DISABLE KEYS */;
INSERT INTO `staging_sites` (`id`, `description`, `location`) VALUES
	(1, 'cns', 'extranodal'),
	(2, 'git', 'extranodal'),
	(3, 'gu', 'extranodal'),
	(4, 'blood', 'extranodal'),
	(5, 'bone', 'extranodal'),
	(6, 'liver', 'extranodal'),
	(7, 'pulmonary_left', 'extranodal'),
	(8, 'pulmonary_right', 'extranodal'),
	(9, 'marrow', 'extranodal'),
	(10, 'orbit_left', 'extranodal'),
	(11, 'orbit_right', 'extranodal'),
	(12, 'skin', 'extranodal'),
	(13, 'salivary_gland_left', 'extranodal'),
	(14, 'salivary_gland_right', 'extranodal'),
	(15, 'thyroid', 'extranodal'),
	(16, 'pericardium', 'extranodal'),
	(17, 'muscle', 'extranodal'),
	(18, 'waldeyer', 'upper_nodal'),
	(19, 'neck_left', 'upper_nodal'),
	(20, 'neck_right', 'upper_nodal'),
	(21, 'infraclavicular_left', 'upper_nodal'),
	(22, 'infraclavicular_right', 'upper_nodal'),
	(23, 'axillary_left', 'upper_nodal'),
	(24, 'axillary_right', 'upper_nodal'),
	(25, 'arm_left', 'upper_nodal'),
	(26, 'arm_right', 'upper_nodal'),
	(27, 'thymus', 'upper_nodal'),
	(28, 'mediastinal', 'upper_nodal'),
	(29, 'hilar_left', 'upper_nodal'),
	(30, 'hilar_right', 'upper_nodal'),
	(31, 'para_aortic', 'lower_nodal'),
	(32, 'mesenteric', 'lower_nodal'),
	(33, 'iliac_left', 'lower_nodal'),
	(34, 'iliac_right', 'lower_nodal'),
	(35, 'inguinal_left', 'lower_nodal'),
	(36, 'inguinal_right', 'lower_nodal'),
	(37, 'popliteal_left', 'lower_nodal'),
	(38, 'popliteal_right', 'lower_nodal'),
	(39, 'spleen', 'lower_nodal');
/*!40000 ALTER TABLE `staging_sites` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.treatment_details
CREATE TABLE IF NOT EXISTS `treatment_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  `type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`,`type_id`),
  KEY `type_id` (`type_id`),
  CONSTRAINT `treatment_details_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `treatment_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2048 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.treatment_details: ~993 rows (approximately)
/*!40000 ALTER TABLE `treatment_details` DISABLE KEYS */;
INSERT INTO `treatment_details` (`id`, `description`, `type_id`) VALUES
	(1, 'ABCM', 3),
	(2, 'ABD', 3),
	(3, 'ABT-199', 6),
	(4, 'ABVD', 3),
	(5, 'ABVD / IFRT', 3),
	(6, 'ABVD / Rituximab', 3),
	(7, 'AC220-02', 6),
	(8, 'ACE CL001: ACP-196', 6),
	(9, 'ACE CL006: Acalabrutinib (ACP-196)', 6),
	(10, 'ACE CL006: Ibrutinib', 6),
	(11, 'ACE CL007: Acalabrutinib (ACP-196)', 6),
	(12, 'ACE CL007: Obinutuzumab / Acalabrutinib (ACP-196)', 6),
	(13, 'ACE CL007: Obinutuzumab / Chlorambucil', 6),
	(14, 'Acerta: ACP-196 (Acalabrutinib)', 6),
	(15, 'Acerta: ACP-196 (Ibrutinib)', 6),
	(16, 'ADE', 3),
	(17, 'ADE / Mylotarg', 3),
	(18, 'ADMIRE (CTRU)', 6),
	(19, 'ADMIRE: FCM-R', 6),
	(20, 'ADMIRE: FCR', 6),
	(21, 'AETHERA (SGN-35)', 6),
	(22, 'AG221: AG221', 6),
	(23, 'AIDA', 3),
	(24, 'AITL (NCRI)', 6),
	(25, 'ALCL99 (NHL 2000 06)', 6),
	(26, 'ALCL99 Guidelines', 3),
	(27, 'Alemtuzumab (conditioning)', 3),
	(28, 'Alemtuzumab / AraC / Bulsulfan / Melphalan (conditioning)', 3),
	(29, 'Alendronate (Fosamax, Fosavance)', 23),
	(30, 'ALL UK 97: non-trial interim guidelines ', 3),
	(31, 'ALL-R3', 6),
	(32, 'ALL-R3: Arm I', 6),
	(33, 'ALL-R3: non-trial interim guidelines', 3),
	(34, 'AMBIT: AC220', 6),
	(35, 'AMBIT: AraC (LD)', 6),
	(36, 'AMBIT: FLAG-Ida', 6),
	(37, 'AMBIT: MEC', 6),
	(38, 'AMG 531 Phase 2 trial', 6),
	(39, 'Amgen AMG 162: 12 weeks', 6),
	(40, 'Amgen AMG 162: 4 weeks', 6),
	(41, 'Amgen AMG 162: Bisphosphonates', 6),
	(42, 'Amgen: Denosumab', 6),
	(43, 'AML 14: AraC', 6),
	(44, 'AML 14: AraC / Mylotarg', 6),
	(45, 'AML 14: ICE', 6),
	(46, 'AML 14: intensive - D35 C200', 6),
	(47, 'AML 14: intensive - D35 C400', 6),
	(48, 'AML 14: intensive - D50 C200', 6),
	(49, 'AML 14: intensive - D50 C400', 6),
	(50, 'AML 14: MidAC', 6),
	(51, 'AML 15: ADE', 6),
	(52, 'AML 15: ADE / Lestaurtinib (CEP-701)', 6),
	(53, 'AML 15: ADE / Mylotarg', 6),
	(54, 'AML 15: APL - MRC protocol', 6),
	(55, 'AML 15: APL - Spanish protocol', 6),
	(56, 'AML 15: APL MRC Arm (MACE / Mylotarg)', 6),
	(57, 'AML 15: APL MRC Arm (MACE)', 6),
	(58, 'AML 15: APL MRC Arm (MidAC)', 6),
	(59, 'AML 15: APL MRC Arm ADE', 6),
	(60, 'AML 15: APL MRC Arm ADE / ATRA', 6),
	(61, 'AML 15: APL Spanish Arm (Ida / ATRA)', 6),
	(62, 'AML 15: APL Spanish Arm (Maintenance)', 6),
	(63, 'AML 15: APL Spanish Arm (Mitox / ATRA / Mylotarg)', 6),
	(64, 'AML 15: APL Spanish Arm (Mitox / ATRA)', 6),
	(65, 'AML 15: AraC', 6),
	(66, 'AML 15: AraC / Mylotarg', 6),
	(67, 'AML 15: DA', 6),
	(68, 'AML 15: DA / Mylotarg', 6),
	(69, 'AML 15: FLAG / Mylotarg', 6),
	(70, 'AML 15: FLAG-lda', 6),
	(71, 'AML 15: FLAG-lda / Mylotarg', 6),
	(72, 'AML 15: Ida / ATRA (consolidation)', 6),
	(73, 'AML 15: MACE', 6),
	(74, 'AML 15: MACE / Mylotarg', 6),
	(75, 'AML 15: MidAC', 6),
	(76, 'AML 15: Mitrox / ATRA (consolidation)', 6),
	(77, 'AML 15: Mitrox / ATRA / Mylotarg (consolidation)', 6),
	(78, 'AML 15: MTX / 6MP / ATRA (maintenance)', 6),
	(79, 'AML 16: intensive - AraC HD', 6),
	(80, 'AML 16: intensive - Azacytidine', 6),
	(81, 'AML 16: intensive - DA', 6),
	(82, 'AML 16: intensive - DA / Mylotarg', 6),
	(83, 'AML 16: intensive - DCLO', 6),
	(84, 'AML 16: intensive - DCLO / Mylotarg', 6),
	(85, 'AML 16: intensive - Mini Allograft', 6),
	(86, 'AML 16: intensive - non Mini-Allograft', 6),
	(87, 'AML 16: intensive ADE', 6),
	(88, 'AML 16: intensive ADE + ATRA', 6),
	(89, 'AML 16: intensive DA + ATRA', 6),
	(90, 'AML 16: no maintenance', 6),
	(91, 'AML 16: non-intensive', 6),
	(92, 'AML 16: non-intensive - AraC LD', 6),
	(93, 'AML 16: non-intensive - AraC LD / Mylotarg', 6),
	(94, 'AML 16: non-intensive - AraC LD / Zarnestra', 6),
	(95, 'AML 16: non-intensive - Clofarabine LD', 6),
	(96, 'AML 16: non-intensive - Sapacitabine', 6),
	(97, 'AML 16: non-intensive - Sapacitabine (LD)', 6),
	(98, 'AML 17: ADE', 6),
	(99, 'AML 17: ADE / Myelotarg - 3mg/mtr sqr', 6),
	(100, 'AML 17: ADE / Myelotarg - 6mg/mtr sqr', 6),
	(101, 'AML 17: AIDA', 6),
	(102, 'AML 17: AIDA (protocol)', 3),
	(103, 'AML 17: Allograft - reduced intensity', 6),
	(104, 'AML 17: Allograft - standard', 6),
	(105, 'AML 17: AraC consolidation - 1 course', 6),
	(106, 'AML 17: AraC consolidation - 2 courses', 6),
	(107, 'AML 17: AraC HD', 6),
	(108, 'AML 17: ATRA (protocol)', 3),
	(109, 'AML 17: ATRA + Arsenic trioxide', 6),
	(110, 'AML 17: ATRA + Arsenic trioxide (protocol)', 3),
	(111, 'AML 17: CEP-701', 6),
	(112, 'AML 17: DA - D 50mg', 6),
	(113, 'AML 17: DA - D 50mg / Gemtuzumab Ozogamicin (Mylotarg)', 6),
	(114, 'AML 17: DA - D 60mg', 6),
	(115, 'AML 17: DA - D 90mg', 6),
	(116, 'AML 17: DA - no further details', 6),
	(117, 'AML 17: DA / Mylotarg - 3mg/mtr sqr', 6),
	(118, 'AML 17: DA / Mylotarg - 6mg/mtr sqr', 6),
	(119, 'AML 17: Daunorubicin / Clofarabine', 6),
	(120, 'AML 17: DClo', 6),
	(121, 'AML 17: Everolimus (Afinitor)', 6),
	(122, 'AML 17: FLAG / IDA', 6),
	(123, 'AML 17: FLAG-Ida', 6),
	(124, 'AML 17: Ifosfamide (protocol)', 3),
	(125, 'AML 17: MACE', 6),
	(126, 'AML 17: MACE / MIDAC', 6),
	(127, 'AML 17: Pacritinib', 6),
	(128, 'AML 17: SCT (allogeneic)', 6),
	(129, 'AML 17: SCT (mini-allograft)', 6),
	(130, 'AML 18 Pilot: DA', 6),
	(131, 'AML 18 Pilot: DA / AC220', 6),
	(132, 'AML 18 Pilot: DAE / AC220', 6),
	(133, 'AML 18 Pilot: DAE/ Ganetespib', 6),
	(134, 'AML 18 Pilot: DCLO', 6),
	(135, 'AML 18 Pilot: DClo / Plerixafor', 6),
	(136, 'AML 18: AC220', 6),
	(137, 'AML 18: AC220 (maintenance)', 6),
	(138, 'AML 18: DA2+5 / AC220', 6),
	(139, 'AML 18: DA2+5 / Cladribine / AC220', 6),
	(140, 'AML 18: DA2+5 / Cladribine / Ganetespib', 6),
	(141, 'AML 18: DA2+5 / Cladribine no small molecule', 6),
	(142, 'AML 18: DA2+5 / Ganetespib', 6),
	(143, 'AML 18: DA2+5 no small molecule', 6),
	(144, 'AML 18: DA50 / AC220', 6),
	(145, 'AML 18: DA50 / Cladribine / AC220', 6),
	(146, 'AML 18: DA50 / Cladribine / Ganetespib', 6),
	(147, 'AML 18: DA50 / Cladribine no small molecule', 6),
	(148, 'AML 18: DA50 / Ganetespib', 6),
	(149, 'AML 18: DA50 no small molecule', 6),
	(150, 'AML 18: DA60 / 1 x Mylotarg', 6),
	(151, 'AML 18: DA60 / 2 x Mylotarg', 6),
	(152, 'AML 18: DA60 alone', 6),
	(153, 'AML 18: FLAG-Ida / AC220', 6),
	(154, 'AML 18: FLAG-Ida / Ganetespib', 6),
	(155, 'AML 18: FLAG-Ida no small molecule', 6),
	(156, 'AML 18: Ganetespib', 6),
	(157, 'AML 18: IDAC / AC220', 6),
	(158, 'AML 18: IDAC / Ganetespib', 6),
	(159, 'AML 18: IDAC no small molecule', 6),
	(160, 'AML 18: Mini FLAG-Ida / AC220', 6),
	(161, 'AML 18: Mini FLAG-Ida / Ganetespib', 6),
	(162, 'AML 18: Mini FLAG-Ida no small molecule', 6),
	(163, 'AML 18: no small molecule', 6),
	(164, 'AML 18: SCT (allograft)', 6),
	(165, 'AML 19: AIDA (Consolidation)', 6),
	(166, 'AML 19: AIDA (Induction)', 6),
	(167, 'AML 19: AraC (HD)', 6),
	(168, 'AML 19: AraC (IT)', 6),
	(169, 'AML 19: Busulfan / Fludarabine', 6),
	(170, 'AML 19: Busulfan / Fludarabine (conditioning)', 6),
	(171, 'AML 19: CPX-351', 6),
	(172, 'AML 19: Cyclophosphamide (conditioning)', 6),
	(173, 'AML 19: Cyclophosphamide / Busulfan (conditioning)', 6),
	(174, 'AML 19: DA / 1 x Mylotarg', 6),
	(175, 'AML 19: DA / 2 x Mylotarg', 6),
	(176, 'AML 19: DA alone', 6),
	(177, 'AML 19: FLAG-Ida / 1 x Mylotarg', 6),
	(178, 'AML 19: FLAG-Ida / 2 x Mylotarg', 6),
	(179, 'AML 19: FLAG-Ida alone', 6),
	(180, 'AML 19: Fludarabine / CPX-351', 6),
	(181, 'AML 19: MACE', 6),
	(182, 'AML 19: MidAC', 6),
	(183, 'AML 19: MRD monitoring arm', 6),
	(184, 'AML 19: No Consolidation', 6),
	(185, 'AML 19: No MRD monitoring', 6),
	(186, 'AML 19: Radiotherapy TBI (conditionaing)', 6),
	(187, 'AML 19: SCT (allograft)', 6),
	(188, 'AML 19: SCT (mini-allograft)', 6),
	(189, 'AML 19: SCT (reduced intensity)', 6),
	(190, 'AML Len5 (CTRU)', 6),
	(191, 'AML Len5: Lenalidomide', 6),
	(192, 'AML Len5: Lenalidomide / ADE', 6),
	(193, 'AML-HR: ADE', 6),
	(194, 'AML-HR: ADE / Atra', 6),
	(195, 'AML-HR: ADE / G-CSF', 6),
	(196, 'AML-HR: FLA', 6),
	(197, 'AML-HR: FLA / Atra', 6),
	(198, 'AML-HR: FLA / G-CSF', 6),
	(199, 'AMN 107 (CML)', 6),
	(200, 'Amsacrine', 3),
	(201, 'Anagrelide', 3),
	(202, 'Apheresis', 2),
	(203, 'AraC (HD)', 3),
	(204, 'Arac (HD) / Dexamethasone / Velcade / Rituximab', 3),
	(205, 'AraC (HD) / Methotrexate / Rituximab', 3),
	(206, 'AraC (HD) / Rituximab', 3),
	(207, 'AraC (HD) / Rituximab / Dexamethasone', 3),
	(208, 'AraC (Intermediate)', 3),
	(209, 'AraC (IT)', 3),
	(210, 'AraC (LD)', 3),
	(211, 'AraC (LD) / Idarubicin', 3),
	(212, 'AraC (NOS)', 3),
	(213, 'AraC / Cisplatin / DHAP', 3),
	(214, 'AraC / Etoposide', 3),
	(215, 'AraC / Methotrexate', 3),
	(216, 'AraC HD  (priming)', 3),
	(217, 'ARCTIC (CTRU)', 6),
	(218, 'ARCTIC: FC / Rituximab', 6),
	(219, 'ARCTIC: FCM-miniR', 6),
	(220, 'Arsenic trioxide', 3),
	(221, 'Asparaginase', 3),
	(222, 'Aspirin', 3),
	(223, 'ATG', 3),
	(224, 'ATG / Bulsuphan / FLASMA (conditioning)', 3),
	(225, 'ATRA', 3),
	(226, 'AVD', 3),
	(227, 'Azacytidine', 3),
	(228, 'Azathioprine', 3),
	(229, 'AZD1152', 6),
	(230, 'BEACOPP', 3),
	(231, 'BEACOPP-e', 3),
	(232, 'BEAM', 3),
	(233, 'BEAM (conditioning)', 3),
	(234, 'BEAM (mini)', 3),
	(235, 'BEAM / Alemtuzumab', 3),
	(236, 'BEAM / Rituximab', 3),
	(237, 'BEAM / Rituximab (conditioning)', 3),
	(238, 'Bendamustine', 3),
	(239, 'Bendamustine / Dexamethasone', 3),
	(240, 'Bendamustine / Prednisolone', 3),
	(241, 'Bendamustine / Rituximab', 3),
	(242, 'BEP', 3),
	(243, 'Bexarotene', 3),
	(244, 'BFORE (AV001): Bosutinib', 6),
	(245, 'BFORE (AV001): Imatinib', 6),
	(246, 'Bisphosphonates', 3),
	(247, 'BiTE: Blinatumomab', 6),
	(248, 'BLAST (NCRN170): Blinatumomab', 6),
	(249, 'Bleomycin', 3),
	(250, 'Blinatumomab', 3),
	(251, 'Blood products', 2),
	(252, 'BMD', 3),
	(253, 'BMT (allograft)', 17),
	(254, 'BMT (autograft)', 17),
	(255, 'BMT (mini-allograft)', 17),
	(256, 'Bortezomib', 3),
	(257, 'Bortezomib Study (mantle cell - phase II): CHOP / Bortezomib', 6),
	(258, 'Bortezomib Study (mantle cell - phase II): CHOP alone', 6),
	(259, 'Bosutinib (Bosulif)', 3),
	(260, 'Brentuximab (Adcetris)', 3),
	(261, 'BREVITY: Brentuximab', 6),
	(262, 'BTD', 3),
	(263, 'Budesonide', 9),
	(264, 'Busulfan', 3),
	(265, 'Busulfan (conditioning)', 3),
	(266, 'C-Thal-Dex (CTD)', 3),
	(267, 'C-Vel-P', 3),
	(268, 'C-weekly', 3),
	(269, 'C-Z-Dex', 3),
	(270, 'CALiBRe: Idelalisib', 6),
	(271, 'CAM203: Campath', 6),
	(272, 'CAM3 (mabCampath)', 6),
	(273, 'Campath', 3),
	(274, 'Campath / Dexamethasone', 3),
	(275, 'CAMPATH / Methylprednisolone', 3),
	(276, 'Campath / Prednisolone', 3),
	(277, 'Capecitabine', 3),
	(278, 'CDR', 3),
	(279, 'Celgene 009 (CLL 009)', 6),
	(280, 'Celgene MDS 005', 6),
	(281, 'CEOP', 3),
	(282, 'Ceplene/IL-2', 3),
	(283, 'CheckMate 205: Nivolumab', 6),
	(284, 'CheckMate 205: Nivolumab / doxorubicin / vinblastine / darcarbazine', 6),
	(285, 'Chelating agents', 2),
	(286, 'CHEMO-T: CHOP', 6),
	(287, 'CHEMO-T: GEM-P', 6),
	(288, 'Chlorambucil', 3),
	(289, 'Chlorambucil / Dexamethasone', 3),
	(290, 'Chlorambucil / Prednisolone', 3),
	(291, 'Chlorambucil / Rituximab', 3),
	(292, 'Chlorambucil / Rituximab Trial (Roche)', 6),
	(293, 'ChlVPP', 3),
	(294, 'ChlVPP / ABVD', 3),
	(295, 'ChlVPP / PABLOE', 3),
	(296, 'CHO', 3),
	(297, 'CHOP', 3),
	(298, 'CHOP / DHAP / Rituximab', 3),
	(299, 'CHOP / IFRT', 3),
	(300, 'CHOP / Rituximab', 3),
	(301, 'CHOP-Campath Trial (UKCRN)', 6),
	(302, 'CHOP-Maxi / AraC(HD)', 3),
	(303, 'CHOP-OR', 6),
	(304, 'CHOP-OR: Ofatumumab (maintenance)', 6),
	(305, 'CHOP-R-Maxi / AraC(HD)', 3),
	(306, 'Cisplatin', 3),
	(307, 'Cladrabine', 3),
	(308, 'Cladrabine / Rituximab', 3),
	(309, 'CLAEG', 3),
	(310, 'CLARITY: observation', 6),
	(311, 'CLASP', 3),
	(312, 'CLEAR', 6),
	(313, 'CLL-009: Lenalidomide', 6),
	(314, 'CLL11: Obinutuzumab / Chlorambucil', 6),
	(315, 'CLL210: Lenalidomide (maintenance)', 6),
	(316, 'CLL210: Ofatumumab, Dexamethasone, Lenalidomide', 6),
	(317, 'CLL4: Chlorambucil', 6),
	(318, 'CLL4: FC', 6),
	(319, 'CLL4: Fludarabine', 6),
	(320, 'CLL5: treated', 6),
	(321, 'CLL5: watch & wait', 6),
	(322, 'CLO + ETOP + CYC', 3),
	(323, 'Clodronate (Bonofos, Clasteon, Loron)', 23),
	(324, 'Clofarabine', 3),
	(325, 'Clofarabine / AraC', 3),
	(326, 'Clopidogrel', 3),
	(327, 'CM', 3),
	(328, 'CMD', 3),
	(329, 'CMML201 (CTRU)', 6),
	(330, 'CODOX-M', 3),
	(331, 'CODOX-M / IVAC', 3),
	(332, 'CODOX-M / IVAC-R', 3),
	(333, 'CODOX-M / Rituximab', 3),
	(334, 'Combined PS341 Trial', 6),
	(335, 'COMPLEMENT 1: Chlorambucil', 6),
	(336, 'Consolidation', 10),
	(337, 'CONTRALTO: Bendamustine / Rituximab', 6),
	(338, 'CONTRALTO: Venetoclax / Bendamustine / Rituximab', 6),
	(339, 'CONTRALTO: Venetoclax / Rituximab', 6),
	(340, 'COP', 3),
	(341, 'COP / COPADM', 3),
	(342, 'COP / Rituximab', 3),
	(343, 'COPAD', 3),
	(344, 'COPADM', 3),
	(345, 'COPADM2', 3),
	(346, 'COPDAC', 3),
	(347, 'COPP', 3),
	(348, 'CORAL: DHAP / Rituximab', 6),
	(349, 'CORAL: ICE / Rituximab', 6),
	(350, 'COSMIC: Bendamustine / Ofatumumab', 6),
	(351, 'COSMIC: Bendamustine / Ofatumumab (mega/HD)', 6),
	(352, 'COSMIC: FC / Ofatumumab', 6),
	(353, 'COSMIC: FC / Ofatumumab (mega/HD)', 6),
	(354, 'CT / Prednisolone', 3),
	(355, 'CTD attenuated (CTDa)', 3),
	(356, 'CVAD', 3),
	(357, 'CVP', 3),
	(358, 'CVP / Rituximab', 3),
	(359, 'CXD101', 6),
	(360, 'Cyclophosphamide', 3),
	(361, 'Cyclophosphamide (conditioning)', 3),
	(362, 'Cyclophosphamide (priming)', 3),
	(363, 'Cyclophosphamide / Campath (conditioning)', 3),
	(364, 'Cyclophosphamide / Dexamethasone', 3),
	(365, 'Cyclophosphamide / MESNA', 3),
	(366, 'Cyclophosphamide / Prednisolone', 3),
	(367, 'Cyclophosphamide / Thalidomide', 3),
	(368, 'Cyclosporin', 3),
	(369, 'Cyclosporin', 19),
	(370, 'CYM', 3),
	(371, 'Cytarabine (IT)', 3),
	(372, 'CYVE', 3),
	(373, 'CYVE / methotrexate', 3),
	(374, 'DA', 3),
	(375, 'DA / Myelotarg', 3),
	(376, 'Danazol', 3),
	(377, 'Danazol', 9),
	(378, 'Daratumumab expanded access program (MMY3010)', 6),
	(379, 'Dasatinib', 3),
	(380, 'DAT', 3),
	(381, 'Daunorubicin', 3),
	(382, 'DCLO', 3),
	(383, 'DEC - MDS', 6),
	(384, 'DECC', 3),
	(385, 'Denosumab (Xgeva)', 3),
	(386, 'Dexamethasone', 9),
	(387, 'DHAP', 3),
	(388, 'DHAP / Rituximab', 3),
	(389, 'DLC 001: Lenalidomide', 6),
	(390, 'Donor lymphocyte infusion', 2),
	(391, 'Doxyrubicin / Adriamycin', 3),
	(392, 'DRC', 3),
	(393, 'DT PACE', 3),
	(394, 'ELASTIC: Azacitidine (3 cycles)', 6),
	(395, 'ELASTIC: Azacitidine (6 cycles)', 6),
	(396, 'ELOQUENT-1: with Elotuzumab', 6),
	(397, 'ELOQUENT-1: without Elotuzumab', 6),
	(398, 'ELOQUENT-2: with Elotuzumab', 6),
	(399, 'ELOQUENT-2: without Elotuzumab', 6),
	(400, 'Eltrombopag', 3),
	(401, 'ENACT: Nilotinib', 6),
	(402, 'ENRICH: Bendamustine / Rituximab', 6),
	(403, 'ENRICH: CHOP / Rituximab', 6),
	(404, 'ENRICH: Ibrutinib (maintenance)', 6),
	(405, 'ENRICH: Ibrutinib / Rituximab', 6),
	(406, 'ENRICH: Rituximab (maintenance)', 6),
	(407, 'EORTC 20981: CHOP', 6),
	(408, 'EORTC 20981: CHOP / Rituximab', 6),
	(409, 'EPIC: Ponatinib', 6),
	(410, 'ESHAP', 3),
	(411, 'ESHAP / R', 3),
	(412, 'EsPhALL (UKALL2003) [Arm not recorded]', 6),
	(413, 'EsPhALL: with Imatinib', 6),
	(414, 'EsPhALL: with Imatinib (protocol)', 3),
	(415, 'EsPhALL: without Imatinib', 6),
	(416, 'Etamsylate', 2),
	(417, 'ETI', 3),
	(418, 'Etidronate (Didronel)', 23),
	(419, 'Etoposide', 3),
	(420, 'Etoposide (conditioning)', 3),
	(421, 'Etoposide / Rituximab', 3),
	(422, 'Etoposide / Rituximab / Dexamethasone', 3),
	(423, 'EuLITE', 6),
	(424, 'EURO-LB 02', 3),
	(425, 'EURO-LB 02', 6),
	(426, 'EURO-LB 02 Induction 1a', 3),
	(427, 'EURO-LB 02 Induction 1b', 3),
	(428, 'EURO-LB 02 Maintenance', 3),
	(429, 'EURO-LB 02 Protocol M', 3),
	(430, 'EURO-LB 02 Re-induction 2a', 3),
	(431, 'EURO-LB 02 Re-induction 2b', 3),
	(432, 'EuroNet-PHL-C1 (Hodgkin)', 3),
	(433, 'EuroNet-PHL-C1 (Hodgkin)', 6),
	(434, 'EuroNet-PHL-C1 (Hodgkins) relapse: BEAM', 6),
	(435, 'EuroNet-PHL-C1 (Hodgkins) relapse: IEP/ABVD', 6),
	(436, 'EuroNet-PHL-C1 (Hodgkins) relapse: Radiotherapy', 6),
	(437, 'EuroNet-PHL-C1 (Hodgkins) relapse: SCT', 6),
	(438, 'EuroNet-PHL-C1 (Hodgkins): OEPA', 6),
	(439, 'EuroNet-PHL-C1 (Hodgkins): OEPA/COP DAC', 6),
	(440, 'EuroNet-PHL-C1 (Hodgkins): OEPA/COPP', 6),
	(441, 'EuroNet-PHL-C1 (Hodgkins): Radiotherapy', 6),
	(442, 'European MCL network: R-CHOP / R-DHAP', 6),
	(443, 'Extracorporeal photopheresis (ECP)', 2),
	(444, 'F-CLL', 6),
	(445, 'FAB LMB 96', 3),
	(446, 'FAB LMB96', 6),
	(447, 'FC', 3),
	(448, 'FC (conditioning)', 3),
	(449, 'FC / ATG (conditioning)', 3),
	(450, 'FC / Campath (conditioning)', 3),
	(451, 'FC / Rituximab', 3),
	(452, 'FIGARO: FB-ATG (conditioning)', 6),
	(453, 'FIGARO: FBA (conditioning)', 6),
	(454, 'FIGARO: FLAMSA-BU', 6),
	(455, 'FIGARO: FMA (conditioning)', 6),
	(456, 'FIRST (MM-020 - Celgene): Arm A', 6),
	(457, 'FIRST (MM-020 - Celgene): Arm B', 6),
	(458, 'FIRST (MM-020 - Celgene): Arm C', 6),
	(459, 'FLA', 3),
	(460, 'FLA / G-CSF (FLAG)', 3),
	(461, 'FLA-Ida', 3),
	(462, 'FLAG', 3),
	(463, 'FLAG / Mylotarg', 3),
	(464, 'FLAG-lda', 3),
	(465, 'FLAG-lda / Myelotarg', 3),
	(466, 'FLAIR: FCR', 6),
	(467, 'FLAIR: Ibrutinib (maintenance)', 6),
	(468, 'FLAIR: Ibrutinib / Rituximab', 6),
	(469, 'FLAMSA', 3),
	(470, 'FLAMSA-BU', 3),
	(471, 'Flu / Bu / Campath', 3),
	(472, 'Flu/Bu/ATG', 3),
	(473, 'FluDAP', 3),
	(474, 'Fludarabine', 3),
	(475, 'Fludarabine (conditioning)', 3),
	(476, 'Fludarabine / Bulsuphan (conditioning)', 3),
	(477, 'Fludarabine / cyclophosphamide / alemtuzumab / methylprednisolone (conditioning)', 3),
	(478, 'Fludarabine / cyclophosphamide / LD-TBI (conditioning)', 3),
	(479, 'Fludarabine / cyclophosphamide / TBI (full intensity conditioning)', 3),
	(480, 'Fludarabine / Melphalan / Campath (conditioning)', 3),
	(481, 'Fludrocortisone', 9),
	(482, 'FMD', 3),
	(483, 'FMD / Rituximab', 3),
	(484, 'FORT (CRUK)', 6),
	(485, 'FORT: Low dose radiotherapy (4Gy in 2 fractions)', 6),
	(486, 'FORT: Standard dose radiotherapy (24Gy in 12 fractions)', 6),
	(487, 'FRALLE-93: Induction (protocol)', 3),
	(488, 'G-CSF', 2),
	(489, 'G-CSF (priming)', 2),
	(490, 'GALACTIC: Obinutuzumab', 6),
	(491, 'GALACTIC: Observation', 6),
	(492, 'Galiximab', 6),
	(493, 'GALLIUM: CVP / Obinutuzumab (GA101)', 6),
	(494, 'GALLIUM: CVP / Rituximab', 6),
	(495, 'GALLIUM: Obinutuzumab (GA101) (maintenance)', 6),
	(496, 'GALLIUM: Rituximab (maintenance)', 6),
	(497, 'GCM-P', 3),
	(498, 'GCM-P / Rituximab', 3),
	(499, 'GCVP', 3),
	(500, 'GCVP / Rituximab', 3),
	(501, 'GEM-P', 3),
	(502, 'GEM-P (GCM-P)', 3),
	(503, 'GEM-P / Rituximab', 3),
	(504, 'GemBex (CRUK)', 6),
	(505, 'Gemcitabine', 3),
	(506, 'Gemcitabine / Cisplatin', 3),
	(507, 'Gemcitabine / Cisplatin / Methylprednisolone', 3),
	(508, 'Gemcitabine / Cisplatin / Prednisolone', 3),
	(509, 'Gemcitabine / Dexamethasone', 3),
	(510, 'Gemcitabine / Methylpredisolone', 3),
	(511, 'Gemcitabine / Prednisolone', 3),
	(512, 'Gemcitabine / Prednisolone / Rituximab / Carboplatin', 3),
	(513, 'Gemcitabine / Rituximab', 3),
	(514, 'GEMOX-R', 3),
	(515, 'GEN406: Ofatumumab', 6),
	(516, 'GEN415: Ofatumumab', 6),
	(517, 'GEN416: Ofatumumab', 6),
	(518, 'Genetech: Obinutuzumab / venetoclax (GDC 0199)', 6),
	(519, 'Genetech: Obinutuzumab / venetoclax (GDC 0199) (maintenance)', 6),
	(520, 'Genmab BIFROST (CLL)', 6),
	(521, 'Genzyme ATG', 6),
	(522, 'Gilead 0115: Bendamustine / Rituximab', 6),
	(523, 'Gilead 0115: Bendamustine / Rituximab / Idelalisib', 6),
	(524, 'Gilead 0115: Idelalisib (maintenance)', 6),
	(525, 'Gilead 0115: Placebo (maintenance)', 6),
	(526, 'Gilead 0119: Ofatumumab', 6),
	(527, 'Gilead 0119: Ofatumumab / Idelalisib', 6),
	(528, 'Gilead 116: Idelalisib / Rituximab', 6),
	(529, 'Gilead 116: Rituximab', 6),
	(530, 'Gilead 117: Idelalisib', 6),
	(531, 'Gilead 125: Bendamustine / Rituximab', 6),
	(532, 'Gilead 125: Idelalisib (maintenance)', 6),
	(533, 'Gilead 125: Placebo (maintenance)', 6),
	(534, 'Gilead 125: Rituximab / Bendamustine / Idelalisib', 6),
	(535, 'Gilead 125: Rituximab / Bendamustine / Placebo', 6),
	(536, 'Gilead 133: Idelalisib / Rituximab', 6),
	(537, 'Granulocyte infusion', 2),
	(538, 'Haemodialysis', 2),
	(539, 'HAM', 3),
	(540, 'HD 200 02 (Hodgkins): ABVD / ChlVPP', 6),
	(541, 'HD 2000 02 (Hodgkin)', 6),
	(542, 'HD-MTX in PCNSL (CRUK)', 6),
	(543, 'HOVON 29 AML', 6),
	(544, 'Hydrocortisone', 9),
	(545, 'Hydroxymethylprednisolone', 3),
	(546, 'Hydroxyurea', 3),
	(547, 'Hydroxyurea / Aspirin', 3),
	(548, 'Hydroxyurea / Clopidogrel', 3),
	(549, 'HyperCVAD', 3),
	(550, 'HyperCVAD / MAG / Rituximab', 3),
	(551, 'HyperCVAD / Rituximab', 3),
	(552, 'Ibandronate (Boniva, Bondronat, Bonviva)', 23),
	(553, 'Ibrutinib (Imbruvica)', 3),
	(554, 'Ibrutinib (maintenance)', 3),
	(555, 'Ibrutinib / Dexamethasone', 3),
	(556, 'Ibrutinib / Rituximab', 3),
	(557, 'ICE', 3),
	(558, 'ICE / Rituximab', 3),
	(559, 'IciCLLe: Ibrutinib', 6),
	(560, 'ICiCLLe: Ibrutinib / obinutuzumab', 6),
	(561, 'IDARAM', 3),
	(562, 'IDARAM Trial', 6),
	(563, 'Idarubicin', 3),
	(564, 'Idelalisib (maintenance)', 3),
	(565, 'Idelalisib (Zydelig)', 3),
	(566, 'Idelalisib / Rituximab', 3),
	(567, 'IELSG19/MALT: Chlorambucil', 6),
	(568, 'IELSG19/MALT: Chlorambucil / Rituximab', 6),
	(569, 'IEP/ABVD', 3),
	(570, 'IFN-a', 3),
	(571, 'IFN-a (eye drops)', 3),
	(572, 'IFN-a / Ara-C', 3),
	(573, 'Ifosfamide / Autograft', 3),
	(574, 'Ifosfamide / Mitoxantrone', 3),
	(575, 'Imatinib', 3),
	(576, 'Immunoglobulins', 2),
	(577, 'INCA: GemRCVP', 6),
	(578, 'INCA: IORCVP', 6),
	(579, 'Infant ALL interim guidelines', 3),
	(580, 'Infinity: Duvelisib', 6),
	(581, 'Infinity: Duvesilib / Obinutuzumab', 6),
	(582, 'Infinity: Duvesilib / Obinutuzumab (maintenance)', 6),
	(583, 'Infinity: Duvesilib / Rituximab', 6),
	(584, 'Infinity: Duvesilib / Rituximab (maintenance)', 6),
	(585, 'Infinity: Ofatumumab ', 6),
	(586, 'INNOVATE: Arm A - Inotuzumab', 6),
	(587, 'INNOVATE: Arm B - AraC / Mitoxantrone', 6),
	(588, 'INNOVATE: Arm B - FLAG', 6),
	(589, 'INNOVATE: Arm B - HIDAC', 6),
	(590, 'INO-VATE: Inotuzumab', 6),
	(591, 'Inter-B-NHL Ritux 2010: Group B (COP)', 6),
	(592, 'Inter-B-NHL Ritux 2010: Group B (COPADM)', 6),
	(593, 'Inter-B-NHL Ritux 2010: Group B (COPADM-R)', 6),
	(594, 'Inter-B-NHL Ritux 2010: Group B (CYM)', 6),
	(595, 'Inter-B-NHL Ritux 2010: Group B (CYM-R)', 6),
	(596, 'Inter-B-NHL Ritux 2010: Group C1 (COP)', 6),
	(597, 'Inter-B-NHL Ritux 2010: Group C1 (COPADM)', 6),
	(598, 'Inter-B-NHL Ritux 2010: Group C1 (COPADM-R)', 6),
	(599, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE CNS+ve)', 6),
	(600, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE CNS-ve)', 6),
	(601, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE-R CNS+ve)', 6),
	(602, 'Inter-B-NHL Ritux 2010: Group C1 (CYVE-R CNS-ve)', 6),
	(603, 'Inter-B-NHL Ritux 2010: Group C1 (M1)', 6),
	(604, 'Inter-B-NHL Ritux 2010: Group C1 (M2)', 6),
	(605, 'Inter-B-NHL Ritux 2010: Group C3 (COP)', 6),
	(606, 'Inter-B-NHL Ritux 2010: Group C3 (COPADM)', 6),
	(607, 'Inter-B-NHL Ritux 2010: Group C3 (COPADM-R)', 6),
	(608, 'Inter-B-NHL Ritux 2010: Group C3 (IT-CYVE)', 6),
	(609, 'Inter-B-NHL Ritux 2010: Group C3 (IT-CYVE-MTX)', 6),
	(610, 'Inter-B-NHL Ritux 2010: Group C3 (M1)', 6),
	(611, 'Inter-B-NHL Ritux 2010: Group C3 (M2)', 3),
	(612, 'Inter-B-NHL Ritux 2010: Group C3 (M2)', 6),
	(613, 'Inter-B-NHL Ritux 2010: Group C3 (R-IT-CYVE)', 6),
	(614, 'Inter-B-NHL Ritux 2010: Group C3 (R-IT-CYVE-MTX)', 6),
	(615, 'INTERFANT 06', 6),
	(616, 'INTERFANT 06 protocol', 3),
	(617, 'INTERFANT 06: ADE', 6),
	(618, 'INTERFANT 06: Allograft', 6),
	(619, 'INTERFANT 06: Experimental arm', 6),
	(620, 'INTERFANT 06: Induction', 6),
	(621, 'INTERFANT 06: MAE', 6),
	(622, 'INTERFANT 06: Maintenance', 6),
	(623, 'INTERFANT 06: MARMA', 6),
	(624, 'INTERFANT 06: OCTADA', 6),
	(625, 'INTERFANT 06: OCTADAD', 6),
	(626, 'INTERFANT 06: Protocol IB', 6),
	(627, 'INTERFANT 06: SCT', 6),
	(628, 'INTERFANT 06: Standard arm', 6),
	(629, 'INTERFANT 99', 6),
	(630, 'IPI-145 / Bendamustine / Rituximab', 6),
	(631, 'IPI-145 / Rituximab', 6),
	(632, 'Iron', 2),
	(633, 'ITCL (high dose)', 6),
	(634, 'IVAC', 3),
	(635, 'IVAC / Rituximab', 3),
	(636, 'IVE', 3),
	(637, 'IVE / Rituximab', 3),
	(638, 'JAKARTA', 6),
	(639, 'KHK2823', 6),
	(640, 'KW-2478: KW-2478 / Bortezomib', 6),
	(641, 'LEAM', 3),
	(642, 'LEAM (conditioning)', 3),
	(643, 'LEGEND: Lenalidomide (maintenance)', 6),
	(644, 'LEGEND: LR-GEM', 6),
	(645, 'LEGEND: R-GEM-P', 6),
	(646, 'LEGEND: RG-EMP', 6),
	(647, 'Lenalidomide', 3),
	(648, 'Lenalidomide (maintenance)', 3),
	(649, 'LenaRIC: Lenalidomide (maintenance)', 6),
	(650, 'Lestaurtinib(CEP 701)', 3),
	(651, 'LI-1: AraC (Cytarabine) / AC220', 6),
	(652, 'LI-1: AraC (Cytarabine) / Vosaroxin', 6),
	(653, 'LI-1: AraC (Cytarabine) alone', 6),
	(654, 'LI-1: Sapacitabine', 6),
	(655, 'LI-1: Vosaroxin alone', 6),
	(656, 'LUCID (Biogen)', 6),
	(657, 'LY05: FC', 6),
	(658, 'LY05: FC / Rituximab', 6),
	(659, 'LY10: high risk - CODOX-M / IVAC', 6),
	(660, 'LY10: low risk - CODOX-M', 6),
	(661, 'LY10: untreated', 6),
	(662, 'LYM-1: maintenance only', 6),
	(663, 'LYM-1: no purge / maintenance', 6),
	(664, 'LYM-1: purging / maintenance', 6),
	(665, 'LYM-1: purging only', 6),
	(666, 'MaBLe: Bendamustine / Rituximab', 6),
	(667, 'MaBLe: Chlorambucil / Rituximab', 6),
	(668, 'MAC UCBT: Busulfan / Cyclophosphamide / Melphalan (conditioning)', 6),
	(669, 'MAC UCBT: Fludarabine / Cyclophosphamide (conditioning)', 6),
	(670, 'MAC UCBT: Radiotherapy (TBI)', 6),
	(671, 'MAC UCBT: Umbilical cord transplant', 6),
	(672, 'MACE', 3),
	(673, 'MAG', 3),
	(674, 'MAG-R', 3),
	(675, 'MAIA: Daratumumab / Lenalidomide / Dexamethasone', 6),
	(676, 'MAIA: Lenalidomide / Dexamethasone', 6),
	(677, 'MAJIC: Busulfan / Hydroxyurea / Anagrelide', 6),
	(678, 'MAJIC: clinician choice (Anagrelide)', 6),
	(679, 'MAJIC: clinician choice (Busulfan)', 6),
	(680, 'MAJIC: clinician choice (Hydroxyurea)', 6),
	(681, 'MAJIC: Ruxolitinib', 6),
	(682, 'Mantle Cell P3: FC', 6),
	(683, 'Mantle Cell P3: FCR', 6),
	(684, 'MARALL: Veltuzumab / Epratuzumab', 6),
	(685, 'MATRIX', 3),
	(686, 'MCOP', 3),
	(687, 'MCOP / Rituximab', 3),
	(688, 'MDM2 Inhibitor', 3),
	(689, 'MDS-Bio1 ', 6),
	(690, 'MDT', 3),
	(691, 'Mel-Dex', 3),
	(692, 'Melphalan', 3),
	(693, 'Melphalan (conditioning)', 3),
	(694, 'Melphalan / Prednisolone', 3),
	(695, 'Mercaptopurine', 3),
	(696, 'Mercaptopurine / Methotrexate', 3),
	(697, 'MERIT (NCRI)', 6),
	(698, 'Methotrexate', 3),
	(699, 'Methotrexate (HD prophylaxis)', 3),
	(700, 'Methotrexate (HD)', 3),
	(701, 'Methotrexate (IT prophylaxis)', 3),
	(702, 'Methotrexate (IT)', 3),
	(703, 'Methotrexate (prophylaxis)', 3),
	(704, 'Methotrexate + Cytarabine', 3),
	(705, 'Methotrexate / AraC / Hydrocortisone (IT)', 3),
	(706, 'Methylprednisolone', 9),
	(707, 'MidAC', 3),
	(708, 'Millennium: Ixazomib Citrate (maintenance)', 6),
	(709, 'Mini-BEAM', 3),
	(710, 'Mini-MIDAC', 3),
	(711, 'Mitoxantrone', 3),
	(712, 'MPT', 3),
	(713, 'MRC UKALL 2003 (regimen A)', 3),
	(714, 'MRC UKALL 2003 (regimen B)', 3),
	(715, 'MRC UKALL 2003 (regimen C)', 3),
	(716, 'MUD peripheral', 17),
	(717, 'MUK 5: CCD', 6),
	(718, 'MUK 5: CVD', 6),
	(719, 'MUK 5: no maintenance', 6),
	(720, 'MUK One', 6),
	(721, 'Mycophenolate', 19),
	(722, 'Myeloma IX: CTDa', 6),
	(723, 'Myeloma IX: intensive - CTD', 6),
	(724, 'Myeloma IX: intensive - CVAD', 6),
	(725, 'Myeloma IX: MP', 6),
	(726, 'Myeloma IX: Observation', 6),
	(727, 'Myeloma IX: Thalidomide', 6),
	(728, 'Myeloma X: Cyclosphosphamide', 6),
	(729, 'Myeloma X: HD Melphalan / ASCT', 6),
	(730, 'Myeloma X: PAD', 6),
	(731, 'Myeloma XI: intensive - ASCT', 6),
	(732, 'Myeloma XI: intensive - CCRD', 6),
	(733, 'Myeloma XI: intensive - CTD', 6),
	(734, 'Myeloma XI: intensive - HD Melphalan', 6),
	(735, 'Myeloma XI: intensive - no chemo', 6),
	(736, 'Myeloma XI: intensive - no maintenance', 6),
	(737, 'Myeloma XI: intensive - RCD', 6),
	(738, 'Myeloma XI: intensive - Revlimid / Vorinostat maintenance', 6),
	(739, 'Myeloma XI: intensive - Revlimid maintenance', 6),
	(740, 'Myeloma XI: intensive - VCD', 6),
	(741, 'Myeloma XI: non-intensive - CTDa', 6),
	(742, 'Myeloma XI: non-intensive - no chemo', 6),
	(743, 'Myeloma XI: non-intensive - no maintenance', 6),
	(744, 'Myeloma XI: non-intensive - RCDa', 6),
	(745, 'Myeloma XI: non-intensive - Revlimid / Vorinostat maintenance', 6),
	(746, 'Myeloma XI: non-intensive - Revlimid maintenance', 6),
	(747, 'Myeloma XI: non-intensive - VCD', 6),
	(748, 'Mylotarg', 3),
	(749, 'National Cord Blood Study (RIC): Radiotherapy (TBI)', 6),
	(750, 'National Cord Blood Study (RIC): Stem cell transplant (allogeneic)', 6),
	(751, 'National Cord Blood Study (RK): Cyclophosphamide / Fludarabine (conditioning)', 6),
	(752, 'NCI - Galiximab', 6),
	(753, 'NCRI CHOP/Velcade (Mantle Cell) [Arm not recorded]', 6),
	(754, 'NCRI FL: CMD', 6),
	(755, 'NCRI FL: FMD', 6),
	(756, 'NCRI Hodgkin (Stanford V)', 6),
	(757, 'NCRI Hodkgin (ABVD)', 6),
	(758, 'NCRI Mantle Cell Phase III', 6),
	(759, 'NCRI PET (Hodgkin)', 6),
	(760, 'NCRI R-CODOX-M/IVAC', 6),
	(761, 'NCRI RATHL', 6),
	(762, 'NCRN-2993: Daratumumab / REV/DEX', 6),
	(763, 'NCRN-2993: REV/DEX', 6),
	(764, 'Nelarabine (Arranon, Atriance)', 3),
	(765, 'NHL Guidelines: Group A (COPAD)', 3),
	(766, 'NHL Guidelines: Group B (COP)', 3),
	(767, 'NHL Guidelines: Group B (COPADM)', 3),
	(768, 'NHL Guidelines: Group B (CYM)', 3),
	(769, 'NHL Guidelines: Group C (COP)', 3),
	(770, 'NHL Guidelines: Group C (COPADM)', 3),
	(771, 'NHL Guidelines: Group C (CYVE CNS+ve)', 3),
	(772, 'NHL Guidelines: Group C (CYVE CNS-ve)', 3),
	(773, 'NHL Guidelines: Group C (M2)', 3),
	(774, 'NHL Guidelines: Group C (M4)', 3),
	(775, 'NHL guidelines: Group C - COPADM', 3),
	(776, 'NHL guidelines: Group C - CYVE', 3),
	(777, 'NHL guidelines: Group C - M1', 3),
	(778, 'NHL guidelines: Group C - M2+M4', 3),
	(779, 'NHL guidelines: Group C - M3', 3),
	(780, 'Nilotinib', 3),
	(781, 'Novartis CAMN 2303', 6),
	(782, 'Obinutuzumab / Chlorambucil', 3),
	(783, 'Obinutuzumab / Chlorambucil / Methylprednisolone', 3),
	(784, 'OEPA', 3),
	(785, 'OEPA/COPP', 3),
	(786, 'Ofatumumab (Arzerra)', 3),
	(787, 'Ofatumumab / Chlorambucil', 3),
	(788, 'Ofatumumab Study (Mantle Cell Phase II)', 6),
	(789, 'OMB110913: FC', 6),
	(790, 'OMB110913: FC / Ofatumumab', 6),
	(791, 'OPPA', 3),
	(792, 'ORCHARRD: Ofatumumab / DHAP', 6),
	(793, 'ORCHARRD: Rituximab / DHAP', 6),
	(794, 'Orthopaedic stabilisation', 2),
	(795, 'P32', 10),
	(796, 'PACE', 3),
	(797, 'PACIFICO: CVP-R', 6),
	(798, 'PACIFICO: FC-R', 6),
	(799, 'PACIFICO: Rituximab Maintenance', 6),
	(800, 'PAD', 3),
	(801, 'PADIMAC: Autograft', 6),
	(802, 'PADIMAC: PAD', 6),
	(803, 'PAIReD: BEAM / Campath (conditioning)', 6),
	(804, 'Palifermin', 2),
	(805, 'Palliative', 10),
	(806, 'Pamidronate (Aredia, Pamimed)', 23),
	(807, 'Panobinostat', 3),
	(808, 'PCYC: Ibrutinib / Lenalidomide / Rituximab', 6),
	(809, 'PECC', 3),
	(810, 'Pentostatin', 3),
	(811, 'PET (Hodgkin): ABVD', 6),
	(812, 'PET (Hodgkin): no radiotherapy', 6),
	(813, 'PET (Hodgkin): Radiotherapy', 6),
	(814, 'PI3K inhibitor trial: Part A (Copanlisib: BAY80-6946)', 6),
	(815, 'PI3K inhibitor trial: Part B (Copanlisib: BAY80-6946)', 6),
	(816, 'Pixantrone', 3),
	(817, 'Plasma exchange', 2),
	(818, 'Plerixafor', 2),
	(819, 'Plerixafor', 3),
	(820, 'Plerixafor (priming)', 2),
	(821, 'PMitCEBO', 3),
	(822, 'PmitCEBO / Rituximab', 3),
	(823, 'Pollux: Daratumumab / Lenalidomide / Dexamethasone', 6),
	(824, 'Pollux: Lenalidomide / Dexamethasone', 6),
	(825, 'Pomalidomide (Imnovid)', 3),
	(826, 'Pomalidomide / Dexamethasone', 3),
	(827, 'Ponatinib (Iclusig)', 3),
	(828, 'Prednisolone', 9),
	(829, 'ProT4: with donor lymphocyte infusion', 6),
	(830, 'ProT4: without donor lymphocyte infusion', 6),
	(831, 'PT-1: Aspirin / Anagrelide', 6),
	(832, 'PT-1: Aspirin / Hydroxycarbamide (Hydroxyurea)', 6),
	(833, 'PT-1: Aspirin only', 6),
	(834, 'PT1 [Arm not recorded]', 6),
	(835, 'PUVA', 4),
	(836, 'QuANTUM-R: Quizartinib (AC220)', 6),
	(837, 'QuANTUM-R: Salvage - FLAG-IDA', 6),
	(838, 'QuANTUM-R: Salvage - LoDAC', 6),
	(839, 'QuANTUM-R: Salvage - MEC', 6),
	(840, 'R-CHOP: 14', 6),
	(841, 'R-CHOP: 21', 6),
	(842, 'R-CODOX-M/IVAC Trial', 6),
	(843, 'R2W: BCR', 6),
	(844, 'R2W: FCR', 6),
	(845, 'RAPID (NCRI)', 6),
	(846, 'RAPID (NCRI): ABVD (1 cycle)', 6),
	(847, 'RAPID (NCRI): ABVD (3 cycles)', 6),
	(848, 'RAPID (NCRI): No further treatment', 6),
	(849, 'RAPID (NCRI): Radiotherapy', 6),
	(850, 'Rasburicase (Elitek, Fasturtec)', 2),
	(851, 'RATHL: ABVD', 6),
	(852, 'RATHL: AVD', 6),
	(853, 'RATHL: BEACOPP-14', 6),
	(854, 'RATHL: BEACOPP-escalated', 6),
	(855, 'RATHL: Radiation', 6),
	(856, 'RATHL: Salvage Therapy', 6),
	(857, 'RAvVA: 5Azacitidine / Vorinostat', 6),
	(858, 'RAvVA: 5Azacitidine alone', 6),
	(859, 'RAY: Ibrutinib', 6),
	(860, 'RAY: Temsirolimus', 6),
	(861, 'RCD', 3),
	(862, 'RCDa', 3),
	(863, 'RD-PACE', 3),
	(864, 'Regimen B Consolidation BFM (protocol)', 3),
	(865, 'Relapsed AML 2001/01: L-DNR / FLAG', 6),
	(866, 'REMoDL-B: Methotrexate', 6),
	(867, 'REMoDL-B: R-CHOP', 6),
	(868, 'REMoDL-B: R-CHOP / Bortezomib', 6),
	(869, 'RESONATE-2: Chlorambucil', 6),
	(870, 'RESONATE-2: Ibrutinib', 6),
	(871, 'RESONATE: Ibrutinib', 6),
	(872, 'RESONATE: Ofatumumab', 6),
	(873, 'REV/DEX', 3),
	(874, 'RGCVP (CRUK)', 6),
	(875, 'RIALtO: Idelalisib or placebo', 6),
	(876, 'RIALtO: Ofatumumab / Bendamustine', 6),
	(877, 'RIALtO: Ofatumumab / Chlorambucil', 6),
	(878, 'RICAZA: Azacitidine', 6),
	(879, 'Risedronate (Actonel, Atelvia, Benet)', 23),
	(880, 'Rituximab', 3),
	(881, 'Rituximab (maintenance)', 3),
	(882, 'Rituximab / Prednisolone', 3),
	(883, 'RO5045337', 6),
	(884, 'ROBUST: Ruxolitinib', 6),
	(885, 'Roche M020927: Chlorambucil', 6),
	(886, 'Roche M020927: Chlorambucil / Rituximab', 6),
	(887, 'Roche MDM2: (Arm A) RO5045377 / Cytarabine', 6),
	(888, 'Roche MDM2: (Arm B) RO5045377 / Cytarabine', 6),
	(889, 'Romidepsin', 3),
	(890, 'Romiplostim (thrombopoeitin analogue)', 2),
	(891, 'Ruxolitinib', 3),
	(892, 'SADAL: Selinexor (HD)', 6),
	(893, 'SADAL: Selinexor (LD)', 6),
	(894, 'Sapacitabine', 3),
	(895, 'SCORAD III: Multiple Fractions', 6),
	(896, 'SCORAD III: Single Fraction', 6),
	(897, 'SDX-101', 6),
	(898, 'SHEILD', 6),
	(899, 'SHIELD: VEPEMB', 6),
	(900, 'Sirolimus / Idelalisib', 3),
	(901, 'SMILE protocol', 3),
	(902, 'SOPRA: Selinexor', 6),
	(903, 'Sorafenib (Nexavar)', 3),
	(904, 'Spanish APML protocol', 3),
	(905, 'Spanish Protocol (APML) High risk Consolidation (I)', 3),
	(906, 'Spanish Protocol (APML) High risk Consolidation (II)', 3),
	(907, 'Spanish Protocol (APML) High risk Consolidation (III)', 3),
	(908, 'Spanish Protocol (APML) High risk Induction', 3),
	(909, 'Spanish Protocol (APML) Maintenance', 3),
	(910, 'Spanish Protocol (APML) MRD+ Consolidation (III)', 3),
	(911, 'Spanish Protocol (APML) Standard risk Consolidation (I)', 3),
	(912, 'Spanish Protocol (APML) Standard risk Consolidation (II)', 3),
	(913, 'Spanish Protocol (APML) Standard risk Induction', 3),
	(914, 'SPIRIT II: Dasatinib 100', 6),
	(915, 'SPIRIT II: Dasatinib 100 (protocol)', 3),
	(916, 'SPIRIT II: Imatinib 400', 6),
	(917, 'SPIRIT II: Imatinib 400 (protocol)', 3),
	(918, 'SPIRIT II: Nilotinib (protocol)', 3),
	(919, 'SPIRIT: Imatinib / peg-IFN', 6),
	(920, 'SPIRIT: Imatinib 400', 6),
	(921, 'SPIRIT: Imatinib 800', 6),
	(922, 'Stanford V: ABVD', 6),
	(923, 'Stanford V: no radiotherapy', 6),
	(924, 'Stanford V: radiotherapy', 6),
	(925, 'Stanford V: Stanford V', 6),
	(926, 'STRATUS: Pomalidomide / Dexamethasone', 6),
	(927, 'Tacrolimus', 3),
	(928, 'Tacrolimus', 19),
	(929, 'TBI', 10),
	(930, 'TEAMM Study: Placebo / Antibiotics', 6),
	(931, 'Thalidomide', 3),
	(932, 'Thalidomide (maintenance)', 3),
	(933, 'Thalidomide / Dexamathasone', 3),
	(934, 'Thalidomide / Prednisolone', 3),
	(935, 'Thiotepa (conditioning)', 3),
	(936, 'TIDE', 3),
	(937, 'Topical steroids', 9),
	(938, 'TOPPS: Group A (with prophylaxis)', 6),
	(939, 'TOPPS: Group B (without prophylaxis)', 6),
	(940, 'Tosedostat', 3),
	(941, 'TOWER: AraC (HD) / Vincristine / Methotrexate (IT)', 6),
	(942, 'Tranexamic acid', 2),
	(943, 'TREATT: Tranexamic acid / placebo', 6),
	(944, 'Treosulphan (conditioning)', 3),
	(945, 'TSET', 3),
	(946, 'UK Haplo: Cyclophosphamide HD (conditioning)', 6),
	(947, 'UK Haplo: Donor lymphocyte infusion', 6),
	(948, 'UK Haplo: Fludarabine / cyclophosphamide (LD) / cyclophosphamide (HD) (conditioning)', 6),
	(949, 'UK Haplo: Radiotherapy TBI (conditioning)', 6),
	(950, 'UK Haplo: Stem cell transplant (allograft)', 6),
	(951, 'UKALL 10 schedule', 3),
	(952, 'UKALL 12 (NCRI)', 6),
	(953, 'UKALL 12 schedule', 3),
	(954, 'UKALL 12: AraC (priming)', 6),
	(955, 'UKALL 12: AraC IT', 6),
	(956, 'UKALL 12: AraC IT (protocol)', 3),
	(957, 'UKALL 12: Consolidation', 6),
	(958, 'UKALL 12: Consolidation (protocol)', 3),
	(959, 'UKALL 12: Cyclosporin', 6),
	(960, 'UKALL 12: Etoposide (conditioning)', 6),
	(961, 'UKALL 12: GCSF (priming)', 6),
	(962, 'UKALL 12: Imatinib maintenance', 6),
	(963, 'UKALL 12: Induction - phase 1', 6),
	(964, 'UKALL 12: Induction - phase 1 (protocol)', 3),
	(965, 'UKALL 12: Induction - phase 2 - with Imatinib', 6),
	(966, 'UKALL 12: Induction - phase 2 - with Imatinib (protocol)', 3),
	(967, 'UKALL 12: Induction - phase 2 - without Imatinib', 6),
	(968, 'UKALL 12: Induction - phase 2 - without Imatinib (protocol)', 3),
	(969, 'UKALL 12: Intensification', 6),
	(970, 'UKALL 12: Intensification (protocol)', 3),
	(971, 'UKALL 12: Maintenance', 6),
	(972, 'UKALL 12: Maintenance (protocol)', 3),
	(973, 'UKALL 12: Methotrexate IT', 6),
	(974, 'UKALL 12: Methotrexate IT (protocol)', 3),
	(975, 'UKALL 12: Methotrexate oral', 6),
	(976, 'UKALL 12: Mitoxantrone (priming)', 6),
	(977, 'UKALL 12: Radiotherapy', 6),
	(978, 'UKALL 12: Radiotherapy (protocol)', 3),
	(979, 'UKALL 12: Radiotherapy TBI (conditioning)', 6),
	(980, 'UKALL 12: Stem cell transplant (allograft)', 6),
	(981, 'UKALL 12: Stem cell transplant (autograft)', 6),
	(982, 'UKALL 14 (NCRI)', 6),
	(983, 'UKALL 14 (NCRI): Flu / Mel / Campath', 6),
	(984, 'UKALL 14 (NCRI): Sibling Allograft (SCT)', 6),
	(985, 'UKALL 14 schedule', 3),
	(986, 'UKALL 14: Alemtuzumab (conditioning)', 6),
	(987, 'UKALL 14: Consolidation Ph+', 6),
	(988, 'UKALL 14: Consolidation Ph-', 6),
	(989, 'UKALL 14: Consolidation Ph- (protocol)', 3),
	(990, 'UKALL 14: Cyclophosphamide (conditioning)', 6),
	(991, 'UKALL 14: Cyclosporin', 6),
	(992, 'UKALL 14: Etoposide (conditioning)', 6),
	(993, 'UKALL 14: Fludarabine (conditioning)', 6),
	(994, 'UKALL 14: Induction - phase 1 Ph+', 6),
	(995, 'UKALL 14: Induction - phase 1 Ph+ (protocol)', 3),
	(996, 'UKALL 14: Induction - phase 1 Ph-', 6),
	(997, 'UKALL 14: Induction - phase 1 Ph- (protocol)', 3),
	(998, 'UKALL 14: Induction - phase 2 Ph+', 6),
	(999, 'UKALL 14: Induction - phase 2 Ph+ (protocol)', 3),
	(1000, 'UKALL 14: Induction - phase 2 Ph-', 6),
	(1001, 'UKALL 14: Induction - phase 2 Ph- (protocol)', 3),
	(1002, 'UKALL 14: Intensification Ph+', 6),
	(1003, 'UKALL 14: Intensification Ph-', 6),
	(1004, 'UKALL 14: Intensification Ph- (protocol)', 3),
	(1005, 'UKALL 14: Maintenance Ph+', 6),
	(1006, 'UKALL 14: Maintenance Ph+ (protocol)', 3),
	(1007, 'UKALL 14: Maintenance Ph-', 6),
	(1008, 'UKALL 14: Maintenance Ph- (protocol)', 3),
	(1009, 'UKALL 14: Melphalan (conditioning)', 6),
	(1010, 'UKALL 14: Methotrexate', 6),
	(1011, 'UKALL 14: Methotrexate (protocol)', 3),
	(1012, 'UKALL 14: Palfermin P1', 6),
	(1013, 'UKALL 14: Palfermin P2', 6),
	(1014, 'UKALL 14: Radiotherapy', 6),
	(1015, 'UKALL 14: Radiotherapy TBI (conditioning)', 6),
	(1016, 'UKALL 14: Rituximab', 6),
	(1017, 'UKALL 14: Stem cell transplant (allograft)', 6),
	(1018, 'UKALL 2003 Regimen A Consolidation (protocol)', 3),
	(1019, 'UKALL 2003 Regimen A Delayed Intensification (protocol)', 3),
	(1020, 'UKALL 2003 Regimen A Induction (protocol)', 3),
	(1021, 'UKALL 2003 Regimen A Interim Maintenance (protocol)', 3),
	(1022, 'UKALL 2003 Regimen A Maintenance (protocol)', 3),
	(1023, 'UKALL 2003 Regimen B Delayed Intensification (protocol)', 3),
	(1024, 'UKALL 2003 Regimen B Induction (protocol)', 3),
	(1025, 'UKALL 2003 Regimen B Interim Maintenance (protocol)', 3),
	(1026, 'UKALL 2003 Regimen B Maintenance (protocol)', 3),
	(1027, 'UKALL 2003 Regimen B Standard BFM Consolidation (protocol)', 3),
	(1028, 'UKALL 2003 Regimen C Augmented BFM Consolidation (protocol)', 3),
	(1029, 'UKALL 2003 Regimen C Capizzi Interim Maintenance', 6),
	(1030, 'UKALL 2003 Regimen C Capizzi Interim Maintenance (protocol)', 3),
	(1031, 'UKALL 2003 Regimen C Delayed Intensification (protocol)', 3),
	(1032, 'UKALL 2003 Regimen C Induction (protocol)', 3),
	(1033, 'UKALL 2003 Regimen C Maintenance (protocol)', 3),
	(1034, 'UKALL 2003: regimen A', 6),
	(1035, 'UKALL 2003: Regimen A (protocol)', 3),
	(1036, 'UKALL 2003: Regimen A Consolidation', 6),
	(1037, 'UKALL 2003: Regimen A Delayed Intensification (I)', 6),
	(1038, 'UKALL 2003: Regimen A Delayed Intensification (II)', 6),
	(1039, 'UKALL 2003: Regimen A Induction', 6),
	(1040, 'UKALL 2003: Regimen A Interim Maintenance', 6),
	(1041, 'UKALL 2003: Regimen A Maintenance', 6),
	(1042, 'UKALL 2003: regimen B', 6),
	(1043, 'UKALL 2003: Regimen B (protocol)', 3),
	(1044, 'UKALL 2003: Regimen B Capizzi Interim Maintenance', 6),
	(1045, 'UKALL 2003: Regimen B Delayed Intensification (I)', 6),
	(1046, 'UKALL 2003: Regimen B Delayed Intensification (II)', 6),
	(1047, 'UKALL 2003: Regimen B Induction', 6),
	(1048, 'UKALL 2003: Regimen B Interim Maintenance', 6),
	(1049, 'UKALL 2003: Regimen B Maintenance', 6),
	(1050, 'UKALL 2003: Regimen B Standard BFM Consolidation', 6),
	(1051, 'UKALL 2003: regimen C', 6),
	(1052, 'UKALL 2003: Regimen C (protocol)', 3),
	(1053, 'UKALL 2003: Regimen C Augmented BFM Consolidation', 6),
	(1054, 'UKALL 2003: Regimen C Capizzi Interim Maintenance', 6),
	(1055, 'UKALL 2003: Regimen C Delayed Intensification (I)', 6),
	(1056, 'UKALL 2003: Regimen C Delayed Intensification (II)', 6),
	(1057, 'UKALL 2003: Regimen C Induction', 6),
	(1058, 'UKALL 2003: Regimen C Maintenance', 6),
	(1059, 'UKALL 2011 Guidelines: Group A', 3),
	(1060, 'UKALL 2011 Guidelines: Group B', 3),
	(1061, 'UKALL 2011 Guidelines: Group C', 3),
	(1062, 'UKALL 2011 Regimen A Consolidation (protocol)', 3),
	(1063, 'UKALL 2011 Regimen A Delayed Intensification (protocol)', 3),
	(1064, 'UKALL 2011 Regimen A Induction (protocol)', 3),
	(1065, 'UKALL 2011 Regimen A Maintenance (protocol)', 3),
	(1066, 'UKALL 2011 Regimen A Standard Interim Maintenance (protocol)', 3),
	(1067, 'UKALL 2011 Regimen B Consolidation BFM (protocol)', 3),
	(1068, 'UKALL 2011 Regimen B Delayed Intensification (protocol)', 3),
	(1069, 'UKALL 2011 Regimen B Induction (protocol)', 3),
	(1070, 'UKALL 2011 Regimen B Maintenance (protocol)', 3),
	(1071, 'UKALL 2011 Regimen B Standard Interim Maintenance (protocol)', 3),
	(1072, 'UKALL 2011 Regimen C Consolidation Augmented BFM (protocol)', 3),
	(1073, 'UKALL 2011 Regimen C Delayed Intensification (protocol)', 3),
	(1074, 'UKALL 2011 Regimen C Induction (protocol)', 3),
	(1075, 'UKALL 2011 Regimen C Maintenance (protocol)', 3),
	(1076, 'UKALL 2011 Regimen C Standard Interim Maintenance (protocol)', 3),
	(1077, 'UKALL 2011: ', 6),
	(1078, 'UKALL 2011: regimen A', 6),
	(1079, 'UKALL 2011: regimen A - delayed intensification', 6),
	(1080, 'UKALL 2011: regimen A - HD Methotrexate', 6),
	(1081, 'UKALL 2011: regimen A - maintenance A1 (pulses + IT)', 6),
	(1082, 'UKALL 2011: regimen A - maintenance A2 (IT without pulses)', 6),
	(1083, 'UKALL 2011: regimen A - maintenance A3 (pulses without IT)', 6),
	(1084, 'UKALL 2011: regimen A - maintenance A4 (no pulses no IT)', 6),
	(1085, 'UKALL 2011: regimen A - standard interim maintenance', 6),
	(1086, 'UKALL 2011: regimen A consolidation', 6),
	(1087, 'UKALL 2011: regimen A induction - short Dexamethasone', 6),
	(1088, 'UKALL 2011: regimen A induction - standard Dexamethasone', 6),
	(1089, 'UKALL 2011: regimen B', 6),
	(1090, 'UKALL 2011: regimen B - delayed intensification', 6),
	(1091, 'UKALL 2011: regimen B - HD Methotrexate', 6),
	(1092, 'UKALL 2011: regimen B - maintenance B1 (pulses + IT)', 6),
	(1093, 'UKALL 2011: regimen B - maintenance B2 (IT without pulses)', 6),
	(1094, 'UKALL 2011: regimen B - maintenance B3 (pulses without IT)', 6),
	(1095, 'UKALL 2011: regimen B - maintenance B4 (no pulses no IT)', 6),
	(1096, 'UKALL 2011: regimen B - standard interim maintenance', 6),
	(1097, 'UKALL 2011: regimen B consolidation (Berlin Frankfurt Munich protocol)', 6),
	(1098, 'UKALL 2011: regimen B induction - short Dexamethasone', 6),
	(1099, 'UKALL 2011: regimen B induction - standard Dexamethasone', 6),
	(1100, 'UKALL 2011: regimen C', 6),
	(1101, 'UKALL 2011: regimen C - Capizzi interim maintenance', 6),
	(1102, 'UKALL 2011: regimen C - delayed intensification', 6),
	(1103, 'UKALL 2011: regimen C - HD Methotrexate + Asparaginase', 6),
	(1104, 'UKALL 2011: regimen C - maintenance C1 (pulses + IT)', 6),
	(1105, 'UKALL 2011: regimen C - maintenance C2 (IT without pulses)', 6),
	(1106, 'UKALL 2011: regimen C - maintenance C3 (pulses without IT)', 6),
	(1107, 'UKALL 2011: regimen C - maintenance C4 (no pulses no IT)', 6),
	(1108, 'UKALL 2011: regimen C consolidation (augmented Berlin Frankfurt Munich protocol)', 6),
	(1109, 'UKALL 2011: regimen C induction - short Dexamethasone', 6),
	(1110, 'UKALL 2011: regimen C induction - standard Dexamethasone', 6),
	(1111, 'UKALL 60+: regimen A - consolidation', 6),
	(1112, 'UKALL 60+: regimen A - maintenance', 6),
	(1113, 'UKALL 60+: regimen A - phase 1 induction', 6),
	(1114, 'UKALL 60+: regimen A - phase 2 induction', 6),
	(1115, 'UKALL 60+: regimen B - consolidation', 6),
	(1116, 'UKALL 60+: regimen B - intensification', 6),
	(1117, 'UKALL 60+: regimen B - maintenance', 6),
	(1118, 'UKALL 60+: regimen B - phase 1 induction', 6),
	(1119, 'UKALL 60+: regimen B - phase 2 induction', 6),
	(1120, 'UKALL 60+: regimen C - consolidation 1', 6),
	(1121, 'UKALL 60+: regimen C - consolidation 2', 6),
	(1122, 'UKALL 60+: regimen C - maintenance year 1', 6),
	(1123, 'UKALL 60+: regimen C - maintenance year 2', 6),
	(1124, 'UKALL 60+: regimen C - phase 1 induction', 6),
	(1125, 'UKALL 60+: regimen C - phase 2 induction', 6),
	(1126, 'UKALL 60+: regimen D - consolidation', 6),
	(1127, 'UKALL 60+: regimen D - maintenance', 6),
	(1128, 'UKALL 60+: regimen D - phase 1 induction', 6),
	(1129, 'UKALL 60+: regimen D - phase 2 induction', 6),
	(1130, 'UKALL 60+: regimen E - consolidation 1', 6),
	(1131, 'UKALL 60+: regimen E - consolidation 2', 6),
	(1132, 'UKALL 60+: regimen E - consolidation 3', 6),
	(1133, 'UKALL 60+: regimen E - intensification', 6),
	(1134, 'UKALL 60+: regimen E - maintenance', 6),
	(1135, 'UKALL 60+: regimen E - phase 1 induction', 6),
	(1136, 'UKALL 60+: regimen E - phase 2 induction', 6),
	(1137, 'UKALL60+', 3),
	(1138, 'UKALL60+', 6),
	(1139, 'UKCLL01 FCM/FCM-R [Arm not recorded]', 6),
	(1140, 'UKCLL02 CamFlud', 6),
	(1141, 'UKCLL06 CamPred', 6),
	(1142, 'UKCLL07 MRD', 6),
	(1143, 'Ursodeoxycholic acid', 19),
	(1144, 'UV B', 3),
	(1145, 'VAD', 3),
	(1146, 'VALOR: Vosaroxin / AraC vs Placebo / AraC (double blind trial)', 6),
	(1147, 'VAPEC-B / IFRT', 3),
	(1148, 'VCD', 3),
	(1149, 'VCD (Myeloma XI)', 3),
	(1150, 'VCD / Rituximab', 3),
	(1151, 'VCD / Thalidomide', 3),
	(1152, 'Velcade', 3),
	(1153, 'Velcade / Dexamethasone', 3),
	(1154, 'VEPEMB', 3),
	(1155, 'Vinblastine', 3),
	(1156, 'Vinblastine / Prednisolone', 3),
	(1157, 'Vincristine', 3),
	(1158, 'Vincristine / Dexamethasone', 3),
	(1159, 'Vincristine / Methylprednisolone', 3),
	(1160, 'Vincristine / Prednisolone', 3),
	(1161, 'VMP', 3),
	(1162, 'VP / Rituximab', 3),
	(1163, 'VR-CAP', 3),
	(1164, 'VTD', 3),
	(1165, 'Watch & Wait (NCRI): With Rituximab', 6),
	(1166, 'Watch & Wait (NCRI): Without Rituximab', 6),
	(1167, 'WM1: Chlorambucil', 6),
	(1168, 'WM1: Fludarabine', 6),
	(1169, 'Wyeth CML: Bosutinib', 6),
	(1170, 'Wyeth CML: Imatinib', 6),
	(1171, 'Z-DEX', 3),
	(1172, 'Zevalin', 3),
	(1173, 'Zevalin / Rituximab', 3),
	(1174, 'Zoledronate (Zometa, Zomera, Aclasta, Reclast)', 23),
	(1175, 'Zoster study', 6);
/*!40000 ALTER TABLE `treatment_details` ENABLE KEYS */;

-- Dumping structure for table hmrn_test.treatment_types
CREATE TABLE IF NOT EXISTS `treatment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;

-- Dumping data for table hmrn_test.treatment_types: ~29 rows (approximately)
/*!40000 ALTER TABLE `treatment_types` DISABLE KEYS */;
INSERT INTO `treatment_types` (`id`, `description`) VALUES
	(1, 'observation'),
	(2, 'supportive care'),
	(3, 'chemotherapy'),
	(4, 'non-haematological'),
	(5, 'discharged to GP'),
	(6, 'clinical trial'),
	(7, 'venesection'),
	(8, 'resection'),
	(9, 'steroids'),
	(10, 'radiotherapy'),
	(11, 'palliative'),
	(12, 'H. pylori eradication'),
	(13, 'splenectomy'),
	(14, 'community monitoring'),
	(15, 'died pre-treatment'),
	(16, 'refused treatment'),
	(17, 'stem cell transplant'),
	(18, 'erythropoietin'),
	(19, 'immunosuppressive'),
	(20, 'vertebroplasty'),
	(21, 'combination'),
	(22, 'stem cell harvest'),
	(23, 'Bisphosphonates'),
	(24, 'Liverpool care pathway'),
	(25, 'Lost to hospital'),
	(26, 'discharged from haematology'),
	(27, 'telephone clinic'),
	(28, 'survivorship clinic'),
	(29, 'Care of dying pathway');
/*!40000 ALTER TABLE `treatment_types` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
