package LIMS::Controller::ReferralSource;

use strict;

use base 'LIMS::Base';
use LIMS::Local::ExcelHandler;

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $location_type = $self->query->param('lookup');

    $self->tt_params( location_type => $location_type );

    return $self->tt_process;
}

# ------------------------------------------------------------------------------
# just set a flag to skip headers (default .tt shared with a popup) & forward:
sub select : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    $self->stash( skip_wrapper => 1 );
    return $self->forward('default');
}

# ------------------------------------------------------------------------------
# lookup function for new hospital/practice/GP, etc:
sub lookup : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $location_type = $self->query->param('type')
        || return $self->error('no location type passed to '.$self->get_current_runmode);

    my $string = $self->query->param('string')
        || return $self->error('no search string passed to '.$self->get_current_runmode);

    # preserve 'skip_wrapper' flag if passed from form as hidden field:
    if ( my $flag = $self->query->param('skip_wrapper') ) {
        $self->stash( skip_wrapper => $flag );
    }
    
    # need min 3 chars to search:
    return unless length $string >= 3;

    my $xl = LIMS::Local::ExcelHandler->new(); # $self->debug($xl);
    $xl->source($location_type);
	
    # array of hashrefs:
    my $matches = $xl->parse($string); # $self->debug($matches);
	my $file_data = $xl->filedata;

=begin # AJAX/xml:
    my $xml = $self->_format_as_xml($matches);

    # set header type to xml:
    $self->header_props(-type=>'text/xml');

    return $xml;
=cut

    # call-back to highlight search terms in escaped HTML:
    my $q = $self->query; # don't use $self inside callback or get circular ref!
    my $highlight = sub {
        my $str = shift;
        $str =~ s/($string)/$q->b($1)/egi; # highlight search term
        return $str;
    };

    $self->tt_params(
        matches       => $matches,
		file_data	  => $file_data,
        highlight     => $highlight,
        location_type => $location_type,
    );

    $self->tt_process('referralsource/default.tt');
}

# ------------------------------------------------------------------------------
=begin # for ajax function, but too slow for ajax
sub _format_as_xml {
    my $self = shift;
    my $matches = shift;

    my @rs = map {
        sprintf q!<rs id="%s" info="%s">%s</rs>!,
            $_->{code},
            $_->{code},
            $self->query->escapeHTML($_->{display}), # escape eg '&' or output fails
    } @$matches;

    my $results =
        sprintf q!<?xml version="1.0" encoding="utf-8" ?><results>%s</results>!, ( join '', @rs );

    return $results;
}
=cut

1;

