package LIMS::DB::PatientCase;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table   => 'patient_case',

    columns => [
        id                 => { type => 'serial', not_null => 1 },
        patient_id         => { type => 'integer', default => '0', not_null => 1 },
        referral_source_id => { type => 'integer', default => '0', not_null => 1 },
        unit_number        => { type => 'varchar', default => 'UNKNOWN', length => 255, not_null => 1 },
        time               => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'patient_id', 'unit_number', 'referral_source_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
        
        referral_source => {
            class       => 'LIMS::DB::ReferralSource',
            key_columns => { referral_source_id => 'id' },
        },
    ],

    relationships => [
        request => {
            class      => 'LIMS::DB::Request',
            column_map => { id => 'patient_case_id' },
            type       => 'one to many',
        },
        direct_patient_trial => { # added to find previous trial requests
            class => 'LIMS::DB::PatientTrial',
            column_map => { patient_id => 'patient_id' },
            # actual rel is probably 1-2-many (ie arrayref), but I need hashref:
            type => 'one to one', # to force data structure to hashref
        },
# not sure these are correct = but needed to get 'as_tree(force_load =>1)' working
#    patient => {
#      class      => 'LIMS::DB::Patient',
#      column_map => { id => 'patient_id' },
#      type       => 'many to one', # reverse this & see output of as_tree()
#    },
#    location => {
#      class      => 'LIMS::DB::Location',
#      column_map => { id => 'location_id' },
#      type       => 'many to one',
#    },
    ],
);
#=cut

#__PACKAGE__->meta->table('patient_case');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('patient_cases');

1;
