package LIMS::DB::Outreach::QuestionnaireService;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_service',
    
    columns => [
        request_id             => { type => 'integer', not_null => 1 },
        transport_arrangements => { type => 'varchar', length => 25, not_null => 1 },
        transport_difficulty   => { type => 'enum', check_in => [ 'Y', 'N' ],
            default => 'N', not_null => 1 },
        location_preference    => { type => 'enum', default => 'GP', not_null => 1,
            check_in => [ 'GP', 'clinic', 'not stated', 'no preference' ] },
        waiting_duration       => { type => 'integer', not_null => 1 },
        excessive_wait         => { type => 'enum', check_in => [ 'Y', 'N' ],
            default => 'N', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_service');

1;
