print(string.format("############ CoPilotFunctions - PLANE_ICAO: %s",  PLANE_ICAO))

-- require("graphics")

-- default TCAS selector mode [N]ormal
local MODE = "N" 

local LandingLightsOff = false
local LandingLightsOn  = false

local SoundLevel = 0.2

Pass10KLightsOn_Sound  = load_WAV_file(SCRIPT_DIRECTORY .. "vSpeed_Sounds/Pass10000LightsOn.wav")
Pass10KLightsOff_Sound = load_WAV_file(SCRIPT_DIRECTORY .. "vSpeed_Sounds/Pass10000LightsOff.wav")
set_sound_gain(Pass10KLightsOn_Sound,  SoundLevel)
set_sound_gain(Pass10KLightsOff_Sound, SoundLevel)

-- set TCAS mode 'On'
set("AirbusFBW/XPDRTCASMode", 1)

-- ToLiss Airbus  & FF A359 only
if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321" or PLANE_ICAO == "A21N" or PLANE_ICAO == "A359" then
	dataref( "IAS",  "sim/cockpit2/gauges/indicators/airspeed_kts_pilot", "readonly")
	dataref( "VSI",  "sim/cockpit2/gauges/indicators/vvi_fpm_pilot",      "readonly") 
	dataref( "IALT", "sim/cockpit2/gauges/indicators/altitude_ft_pilot",  "readonly")
	dataref( "TGT",  "sim/cockpit/autopilot/altitude",                    "readonly")
	
	if PLANE_ICAO == "A359" then
		LIGHTS = dataref_table("sim/cockpit2/switches/landing_lights_switch")
	else
		LIGHTS = dataref_table("AirbusFBW/OHPLightSwitches")
	end

	do_every_frame("main()")
end

function main()
	set_landing_lights()
	-- A359 doesn't need manual TCAS mode selector
	if PLANE_ICAO ~= "A359" then
		set_tcas_mode_selector()
	end
end

function set_landing_lights()
	-- switch lights off if passing 10K ft and climbing and not already off
	if ( math.floor(IALT) >= 10001 ) and ( math.floor(IALT) <= 10010 ) and ( math.floor(VSI) ) > 0 and ( not SwitchedLightsOff ) then 
		LandingLightsOff = true
		LandingLightsOn  = false
		play_sound(Pass10KLightsOff_Sound) 

		if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321" or PLANE_ICAO == "A21N" then
			LIGHTS[4] = 1   -- Left landing off
			LIGHTS[5] = 1   -- Right landing off
		elseif PLANE_ICAO == "A359" then
			LIGHTS[0] = 0   -- Left landing off
			LIGHTS[1] = 0   -- Right landing off
		end
	end
	-- switch lights on if passing 10K ft and descending and not already on
	if ( math.floor(IALT) <= 9999 ) and ( math.floor(IALT) >= 9990 ) and ( math.floor(VSI) < 0 ) and ( not SwitchedLightsOn ) then 
		LandingLightsOn  = true
		LandingLightsOff = false
		play_sound(Pass10KLightsOn_Sound) 

		if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321" or PLANE_ICAO == "A21N" then
			LIGHTS[4] = 2   -- Left landing on
			LIGHTS[5] = 2   -- Right landing on
		elseif PLANE_ICAO == "A359" then
			LIGHTS[0] = 1   -- Left landing off
			LIGHTS[1] = 1   -- Right landing off
		end
	end
end

function set_tcas_mode_selector()
	-- if we are moving >50kts
	if math.floor(IAS) > 50 then		
		-- if below TGT altitude by more than 100 feet and climbing with vertical rate > +100fpm, set mode to ABV if not already:
		if math.floor(IALT) < ( TGT - 100 ) and math.floor(VSI) > 100 then
			if MODE ~= "ABV" then
				MODE = "ABV"
				set("AirbusFBW/XPDRTCASAltSelect", 0)
			end
		-- if above TGT altitude and decending with vertical rate > -100fpm, set mode to BLW if not already
		elseif math.floor(IALT) > ( TGT + 100 ) and math.floor(VSI) < -100 then
			if MODE ~= "BLW" then
				MODE = "BLW"
				set("AirbusFBW/XPDRTCASAltSelect", 2)
			end
		-- else vertical speed between +100 & -100 fpm, set mode to position 'N'
		elseif ( MODE ~= "N" ) then 
			MODE = "N"
			set("AirbusFBW/XPDRTCASAltSelect", 1)
		end
	end
end

-- ckpt/oh/strobeLight/anim 2 [2=on 1=auto]

-- if >500ft and gear down [AirbusFBW/GearLever = ?], switch ckpt/oh/taxiLight/anim -> 1 [1=taxi, 2=TO]

-- when AirbusFBW/ENGModeSwitch = 2 set sim/cockpit/electrical/beacon_lights_on -> 1