print(string.format("############ CoPilotFunctions - PLANE_ICAO: %s",  PLANE_ICAO))

-- default TCAS selector mode [N]ormal
local MODE = "N"

local LandingLightsOff = false
local LandingLightsOn  = false

local SoundLevel = 0.2

local Pass10KLightsOn_Sound  = load_WAV_file(SCRIPT_DIRECTORY .. "vSpeed_Sounds/Pass10000LightsOn.wav")
local Pass10KLightsOff_Sound = load_WAV_file(SCRIPT_DIRECTORY .. "vSpeed_Sounds/Pass10000LightsOff.wav")

set_sound_gain(Pass10KLightsOn_Sound,  SoundLevel)
set_sound_gain(Pass10KLightsOff_Sound, SoundLevel)

-- ToLiss Airbus & FF A359 only // temporarily disabled A350 pending clarification of datarefs
-- if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321" or PLANE_ICAO == "A359" then
if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321"  or PLANE_ICAO == "A339" then
	dataref( "iAS",  "sim/cockpit2/gauges/indicators/airspeed_kts_pilot", "readonly")
	dataref( "iALT", "sim/cockpit2/gauges/indicators/altitude_ft_pilot",  "readonly")
	dataref( "VSI",  "sim/cockpit2/gauges/indicators/vvi_fpm_pilot",      "readonly")
	dataref( "iGS",  "sim/flightmodel/position/groundspeed",              "readonly")
	dataref( "TGT",  "sim/cockpit/autopilot/altitude",                    "readonly")
	dataref( "TCAS", "AirbusFBW/XPDRTCASMode",	    				      "readonly")
	dataref( "BEACON",   "sim/cockpit2/switches/beacon_on",               "readonly")
	dataref( "ENG_MODE", "AirbusFBW/ENGModeSwitch",					      "readonly")
	dataref( "XPONDER",  "AirbusFBW/XPDRPower",      		              "readonly")
	dataref( "WEATHER",  "AirbusFBW/WXPowerSwitch",                       "readonly")

	LIGHTS = dataref_table("AirbusFBW/OHPLightSwitches") -- array of lights - beacon, strobe, etc

	-- switch MKR off:
	set("sim/cockpit2/radios/actuators/audio_marker_enabled", 0)
	
	do_every_frame("main()")
end

function main()
	set_landing_lights()
	set_beacon()
	set_strobe()
	-- A359 doesn't need manual TCAS mode selector
	if PLANE_ICAO ~= "A359" then
		set_transponder()
		set_tcas_mode_selector()
	end
end

function log_msg(str) -- custom log function
	local temp = os.date("*t", os.time())
	print(string.format("CoPilotFunctions: %02d:%02d:%02d %s", temp.hour, temp.min, temp.sec, str))
end

-- set strobe & landing lights on if thrust levers in FLX or TOGA position and on the ground 
function set_strobe()
    local TLA = XPLMGetDatavf(XPLMFindDataRef("AirbusFBW/throttle_input"), 0, 1)
    local iThrustLevers = TLA[0] -- thrust levers (left lever representing both)
		--log_msg("iThrustLevers: " .. iThrustLevers)

	local sThrustLevers = "IDLE"
	if math.abs(iThrustLevers - 0.88) < 0.05
		then sThrustLevers = "FLX"
    elseif math.abs(iThrustLevers - 1.0) < 0.05
		then sThrustLevers = "TOGA"
	end
		--log_msg("sThrustLevers: " .. sThrustLevers)
	local on_ground = XPLMFindDataRef("sim/flightmodel/forces/fnrml_gear")
	if XPLMGetDataf(on_ground) > 1.0 then iOnGround = 1 else iOnGround = 0 end

	if ( sThrustLevers == "FLX" or sThrustLevers == "TOGA" ) and iOnGround == 1 then
		if ( not StrobeOn ) then
			LIGHTS[7] = 2 -- array position 8
			-- these only move switches, FSFK doesn't detect it
			-- set("sim/cockpit2/switches/strobe_lights_on", 1) -- 1=on 0=off
			-- set("sim/cockpit/electrical/strobe_lights_on, 1) # alternative
			-- set("ckpt/oh/strobeLight/anim", 2) -- 2=on, 1=auto, 0=off
			StrobeOn = true
		end
		-- LandingLightsOn is likely to be false if on ground
		if ( not LandingLightsOn ) then
			switch_landing_lights_on()
		end
	end
end

-- beacon on if engine mode selector to ign/start and beacon not already on
function set_beacon()
	--log_msg("ENG_MODE" .. ENG_MODE)
	--log_msg("BEACON" .. BEACON)
	if ENG_MODE == 2 and BEACON ~= 1 then		
		LIGHTS[0] = 1 -- Beacon on [array position 0]
	end
end

-- set transponder to mode C if moving > 5kts
function set_transponder()
	gs = iGS * 1.9438445 -- ground speed [kts]

	if gs > 1 then
		if XPONDER ~= 4 then
			-- set("ckpt/transponder/mode/anim", 0) -- sets switch but not ECAM display	
			set("AirbusFBW/XPDRPower", 4)
		end
		if TCAS ~= 1 and not ( PLANE_ICAO == "A339" ) then -- A339 uses different dataref
			set("AirbusFBW/XPDRTCASMode", 1)
		end
		if WEATHER ~= 0 then
			set("AirbusFBW/WXPowerSwitch", 0)
		end
	end
end

function set_taxi_lights(val) -- 0=off, 1=on, 2=take-off
	if (PLANE_ICAO == "A339") then -- doesn't have ckpt/oh/taxiLight/anim, uses AirbusFBW/OHPLightSwitches, 
		LIGHTS[3] = val
	else -- TODO ? combine with A339 ?
		set("ckpt/oh/taxiLight/anim", val)
	end
end

function set_landing_lights()
	-- switch lights off if passing 10K ft and climbing and not already off
	if ( math.floor(iALT) >= 10001 ) and ( math.floor(iALT) <= 10010 ) and ( math.floor(VSI) ) > 0 and ( not LandingLightsOff ) then
		switch_landing_lights_off()
		set_taxi_lights(0)
		play_sound(Pass10KLightsOff_Sound)
	end

	-- switch lights on if passing 10K ft and descending and not already on
	if ( math.floor(iALT) <= 9999 ) and ( math.floor(iALT) >= 9990 ) and ( math.floor(VSI) < 0 ) and ( not LandingLightsOn ) then
		switch_landing_lights_on()
		set_taxi_lights(1)
		play_sound(Pass10KLightsOn_Sound)
	end
end

function switch_landing_lights_off()
	--if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321" or PLANE_ICAO == "A21N" then
		--0=retract, 1=off, 2=on
		LIGHTS[4] = 1   -- Left landing off //  position 5 in array,
		if not ( PLANE_ICAO == "A339" ) then -- A339 only has 1 switch
			LIGHTS[5] = 1   -- Right landing off // position 6 in array, 0=retract,1=off,2=on
		end
	--elseif PLANE_ICAO == "A359" then // doesn't work
		-- 0=off [A3xx & A359] & retract [A3xx only], 1=on
		-- LIGHTS[0] = 0   -- Left landing off
		-- LIGHTS[1] = 0   -- Right landing off
	--end

	LandingLightsOff = true
	LandingLightsOn  = false
	log_msg("switched landing lights off")
end

function switch_landing_lights_on()
	--if PLANE_ICAO == "A319" or PLANE_ICAO == "A20N" or PLANE_ICAO == "A321" or PLANE_ICAO == "A21N" then
		--0=retract, 1=off, 2=on
		LIGHTS[4] = 2   -- Left landing on
		if not ( PLANE_ICAO == "A339" ) then -- A339 only has 1 switch
			LIGHTS[5] = 2   -- Right landing on
		end
	--elseif PLANE_ICAO == "A359" then // doesn't work
		-- 0=off [A3xx & A359] & retract [A3xx only], 1=on
		-- LIGHTS[0] = 1   -- Left landing on  // position 1 in array, 
		-- LIGHTS[1] = 1   -- Right landing on // position 2 in array
	--end
	
	LandingLightsOn  = true
	LandingLightsOff = false
	log_msg("switched landing lights on")
end

function set_tcas_mode_selector()
	-- if we are moving >50kts
	if math.floor(iAS) > 50 then
		-- if below TGT altitude by more than 100 feet and climbing with vertical rate > +100fpm, set mode to ABV if not already:
		if math.floor(iALT) < ( TGT - 100 ) and math.floor(VSI) > 100 then
			if MODE ~= "ABV" then
				MODE = "ABV"
				set("AirbusFBW/XPDRTCASAltSelect", 0)
				log_msg( string.format("%.0f", iALT) .. "ft set TCAS mode ABV")
			end
		-- if above TGT altitude and decending with vertical rate > -100fpm, set mode to BLW if not already
		elseif math.floor(iALT) > ( TGT + 100 ) and math.floor(VSI) < -100 then
			if MODE ~= "BLW" then
				MODE = "BLW"
				set("AirbusFBW/XPDRTCASAltSelect", 2)
				log_msg( string.format("%.0f", iALT) .. "ft set TCAS mode BLW")
			end
		-- else vertical speed between +100 & -100 fpm, set mode to position 'N'
		elseif ( MODE ~= "N" ) then
			MODE = "N"
			set("AirbusFBW/XPDRTCASAltSelect", 1)
			log_msg( string.format("%.0f", iALT) .. "ft set TCAS mode N")
		end
	end
end

--[[ todo:
	set taxi & r/w turnoff lights on if >500ft and gear down [AirbusFBW/GearLever = ?]
-]]