package Reporter::Routes::Test;

use Reporter::Class; # provides Moo, Modern::Perl & Data::Printer::p
use Reporter;

use Dancer2 app => 'Reporter';
use Dancer2::Plugin::Deferred; # why do we need this? what is point of 'app' in line above?

prefix '/test';

my $app = Reporter->new(dbname => 'hilis4'); # contains model & db classes

sub flash { deferred @_ } # to use 'old' term

# to test 500.tt custom error template:
get '/error' => sub { send_error('test error message') };

# test flash/deferred:
get '/flash' => sub {
    flash $_ => "test flash $_ message" for qw(info warning danger); # bootstrap helper classes
    redirect '/';
};

1;
