package Reporter::Routes::AJAX;

# to ask: use order critical; need my $app again
use Reporter::Class; # provides Moo, Modern::Perl & Data::Printer::p
use Reporter;
use Dancer2 app => 'Reporter';

set serializer => 'JSON';

my $app = Reporter->new(dbname => 'hilis4'); # contains model & db classes

get '/ajax_get_diagnoses' => sub {
	my $diagnoses = $app->model->get_diagnoses( param('diagnosis') )
	|| return; # p $diagnoses; # doesn't do query unless str >= 3 chars

    my @results = map {
        {
            id    => $_->{id},
            value => $_->{diagnosis},
            info  => $_->{icdo3} || '[non-ICDO3]',
        }
    } @$diagnoses; # p @results;

    my $json = { results => \@results }; # p $json;
    return $json;
};

1;
