package Reporter;

use Reporter::Model;
use Reporter::Validation;
use Reporter::Class; # provides Moo, Modern::Perl, Local::MooX::Types & Data::Printer::p

has dbname => ( is => 'ro', isa => String, required => 1 ); # hilis4, test, etc
has model => (
    is => 'lazy',
    builder => sub { Reporter::Model->new( dbname => shift->dbname ) }
);
has validator => ( # Data::FormValidator:
    is => 'lazy',
    builder  => sub { Reporter::Validation->new( dbname => shift->dbname ) }
);

sub enable_sql_trace { $ENV{SQL_TRACE} = 1 }

sub symbolise { Local::Utils::symbolise($_[1]) }

1;
