package Reporter::Routes::AJAX;

use Dancer2;
use Data::Printer;

use Reporter;

set serializer => 'JSON';

# app, contains model & db classes:
my $app = Reporter->new( config => config() );

hook before => sub { $app->check_db_connection }; # to ensure dbh still connected

# route duplicated in Routes so app.psgi can run a single app (also for bin/app.pl)
get '/get_diagnoses' => sub {
	my $diagnoses = $app->model->get_diagnoses( param('diagnosis') )
	|| return; # p $diagnoses; # doesn't do query unless str >= 3 chars

    my @results = map {
        {
            id    => $_->{id},
            value => $_->{diagnosis},
            info  => $_->{icdo3} || '[non-ICDO3]',
        }
    } @$diagnoses; # ddp \@results;
    return { results => \@results };
};

true;
