use Test::More;

use Reporter::Class;

require_ok( 'Reporter::Test' ); # Data::Printer, Mooo, etc

use Reporter::Test;

my $t = Reporter::Test->new;

{ # invalid lab number (HTML::FormHandler):
    my $res = $t->app->model->validate({ lab_number => 200 }); # p $res;
    is( $res->{failed}, 1, 'OK: lab number validation failed' );
}

{ # valid lab number (HTML::FormHandler):
    my $res = $t->app->model->validate({ lab_number => '200/15' }); # p $res;
    is( $res->{success}, 1, 'OK: lab number validation passed');
}

{ # invalid lab number (HTTP::Validate):
    my $res = $t->app->validator->validate({ lab_number => 200 }); # p $res;
    is( $res->{failed}, 1, 'OK: lab number validation failed' );
}

{ # valid lab number (HTTP::Validate):
    my $res = $t->app->validator->validate({ lab_number => '20/15' }); # p $res;
    is( $res->{success}, 1, 'OK: lab number validation passed' );
}

done_testing(5);