package Reporter::Routes;

use Reporter::Class; # provides Moo, Modern::Perl & Data::Printer::p
use Reporter;
use Dancer2;

use Reporter::Routes::AJAX;

my $app = Reporter->new(dbname => 'hilis4'); # contains model & db classes

hook before => sub {
    # all routes need login (except /login):
    unless ( session('user_profile') ) {
        redirect '/login' unless request->path_info =~ m!^/login!;
    }
    # sql query output to stdout:
    $app->enable_sql_trace if setting('enable_sql_trace'); # development env
};

hook before_template_render => sub {
    my $tokens = shift;
    $tokens->{symbolise} = sub { $app->symbolise(@_) };
    $tokens->{tt_regex}  = $app->tt_regex;
};

# default route:
get '/' => sub {
    template load => { target => uri_for('/load') };
};

# login route:
get '/login' => sub { template 'login' };

# submitted user credentials:
post '/login' => sub {
    my $params = params; # p $params;

    # validate username/password
    if ( my $user = $app->model->authenticate_user($params) ) { # p $user;
        session user_profile => $user;
        redirect '/';
    }
    else { # p 'here';
        my $failed_logins = session('failed_logins') || 0;
        session failed_logins => $failed_logins + 1; # increment
        redirect '/login';
    }
};

get '/load' => sub {
    my $params = params; # p $params;

    # validate lab number format:
    my $result = $app->model->validate($params); # p $result;
    if ( $result->{failed} ) { # p $result->errors;
        my $errs = $result->{errors}; # p $errs;
        return template load => { format_errors => $errs };
    }

    my $data = $app->model->load_request($params->{lab_number});
    template report => { data => $data };
};

post '/report/:request_id' => sub {
    my $params = params;  p $params;
    # my $result = $app->model->validate($params);  p $result; # need to load profile
    return to_json({params => $params });
    
};

# logout route:
get '/logout' => sub {
    app->destroy_session;
    redirect('/'); # should redirect to /login
};

# default Dancer2 app index page:
get '/index' => sub { template 'index', {}, { layout => 'index' } };

#===============================================================================
# http://blog.geekuni.com/2015/06/three-ways-to-implement-sessions.html
get '/count' => sub {
  if ( my $user = session('user') ) {
    session count => session('count') + 1;
    my $ordinal = $app->model->num2ordinal(session('count')); p $ordinal;
    return
        '<a href="/count">Click here</a> for the name of the eldest son of ' .
        '<b>Count von '. ucfirst $user.' the '. ucfirst $ordinal .'</b>';
  }
  return 'Cookie Monster!';
};

get '/do_login/:user' => sub {
    session user   => params->{user};
    session count  => 0;
    redirect '/count';
};
#===============================================================================

dance;
