package Reporter::DB;

use Reporter::SQL::Lib;
use Reporter::Class; # provides Moo, Modern::Perl & Data::Printer::p

use lib '/home/raj/perl-lib';
use Local::DB;

has sql_lib => ( is => 'lazy', builder => sub { Reporter::SQL::Lib->new } );
has dbname  => ( is => 'ro', isa => String, required => 1 ); # hilis4, test, etc
has dbix    => ( is => 'lazy' ); # returns DBIx::Simple object

sub get_user_data {
    my ($self, $userid) = @_; # p $userid;

    my @cols = qw(id username last_name first_name password);
    my %where = ( # active = 'yes' AND ( username = $userid OR email = $userid ):
        -and => [
            { active => 'yes' },
            -or => [ { username => $userid }, { email => $userid } ]
        ]
    );
    my $user = $self->dbix->select('users', \@cols, \%where)->hash; # p $user;
    return $user || 0;
}

sub get_request_data {
    my ($self, $request_number, $yr) = @_;

    my ($sql, @bind) = $self->sql_lib->request_data($request_number, $yr);
    my $data = $self->dbix->query($sql, @bind)->hash; # p $data;
    return $data;
}

sub get_result_summaries {
    my ($self, $request_id) = @_;

    my ($sql, @bind) = $self->sql_lib->result_summaries($request_id);
    my $data = $self->dbix->query($sql, @bind)->hashes; # p $data;
    return $data;
}

sub get_lab_test_results {
    my ($self, $request_id) = @_;

    my ($sql, @bind) = $self->sql_lib->lab_test_results($request_id);
    my $data = $self->dbix->query($sql, @bind)->hashes; # p $data;

    my %h;
    for my $ref (@$data) {
        my ($section, $test) = map $ref->{$_}, qw(section test); # p $section; p $test;
        $h{$section}{$test} = $ref->{result};
    }
    return \%h;
}

sub get_diagnoses {
    my ($self, $str) = @_; # p $str;

    my @cols = qw( id name icdo3 );
    my %where = ( name => { rlike => $str } );
    my $data = $self->dbix->select('diagnoses', \@cols, \%where)->hashes; # p $data;
    #$self->dbix->query('select * from diagnoses where name rlike ?', $str)->hashes;
    return $data;
}

sub _build_dbix {
    my $self = shift;

    my $db = $self->dbname; # dbname = test, hilis4, etc

    my $dbix = ( $db eq 'test' ) # return in memory sqlite dbix object
        ? Local::DB->dbix({ dsn => 'dbi:SQLite:dbname=:memory:' })
        : Local::DB->dbix($db);
    return $dbix;
}

1;
