package Reporter;

use Reporter::Model;
use Reporter::Validator;
use Reporter::Class; # provides Moo, Modern::Perl, Local::MooX::Types & Data::Printer::p

has dbname => ( is => 'ro', isa => String, required => 1 ); # hilis4, test, etc
has model => (
    is => 'lazy',
    builder => sub { Reporter::Model->new( dbname => shift->dbname ) }
);
has validator => ( # HTTP::Validate:
    is => 'lazy',
    builder  => sub { Reporter::Validator->new( dbname => shift->dbname ) }
);

sub enable_sql_trace { $ENV{SQL_TRACE} = 1 }

sub symbolise { Local::Utils::symbolise($_[1]) }

sub tt_regex { # regex for use in report_form.tt
    {
        fixed_or_trephine => 'BMAT|[DGLRXT]([BS][LP]|F|U)',
        histology_type    => '[DGLRX]([BS]L|F|U)',
    }
}

1;
