use strict;
use warnings;

use Reporter::Routes;
use Test::More;

use Plack::Test;
use Data::Printer;
use HTTP::Request::Common;

my $app = Reporter::Routes->to_app;
is( ref $app, 'CODE', 'got app' );

my $test = Plack::Test->create($app);

{
    my $res = $test->request( GET '/' ); # ddp $res->content;

    # fails because '/' redirects to /login
    isnt( $res->is_success, '[GET /] successful', "get '/' failed" );
    is( $res->code, 302, 'redirect code 302');
}
{
    my $res = $test->request( GET '/login' ); # ddp $res->content;
    ok( $res->is_success, '[GET /login] successful' );
}
SKIP: { # test error
    skip( "Routes::Test seems to not load", 1 );
    my $res = $test->request( GET '/test/error' );  ddp $res->content;
    # ok( $res->is_success, '[GET /login] successful' );
}
done_testing();